/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.editparts;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.editparts.IChildEditPartFilter;
import com.archimatetool.editor.diagram.editparts.IEditPartFilterProvider;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class AbstractFilteredEditPart
extends AbstractGraphicalEditPart {
    private IPropertyChangeListener prefsListener;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.addECoreAdapter();
            this.prefsListener = this::applicationPreferencesChanged;
            ArchiPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(this.prefsListener);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.removeECoreAdapter();
            ArchiPlugin.getInstance().getPreferenceStore().removePropertyChangeListener(this.prefsListener);
        }
    }

    protected void addECoreAdapter() {
        if (this.getECoreAdapter() != null) {
            this.getModel().eAdapters().add((Object)this.getECoreAdapter());
        }
    }

    protected void removeECoreAdapter() {
        if (this.getECoreAdapter() != null) {
            this.getModel().eAdapters().remove((Object)this.getECoreAdapter());
        }
    }

    protected abstract Adapter getECoreAdapter();

    protected abstract void applicationPreferencesChanged(PropertyChangeEvent var1);

    public EObject getModel() {
        return (EObject)super.getModel();
    }

    protected List<?> getModelChildren() {
        return this.getFilteredModelChildren();
    }

    protected List<?> getFilteredModelChildren() {
        if (this.getModel() instanceof IDiagramModelContainer) {
            EList originalList = ((IDiagramModelContainer)this.getModel()).getChildren();
            IChildEditPartFilter[] filters = this.getRootEditPartFilterProvider().getEditPartFilters(IChildEditPartFilter.class);
            if (filters != null) {
                ArrayList<IDiagramModelObject> filteredList = new ArrayList<IDiagramModelObject>();
                for (IDiagramModelObject object : originalList) {
                    boolean add = true;
                    IChildEditPartFilter[] iChildEditPartFilterArray = filters;
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IChildEditPartFilter filter = iChildEditPartFilterArray[n2];
                        add = filter.isChildElementVisible((EditPart)this, object);
                        if (!add) break;
                        ++n2;
                    }
                    if (!add) continue;
                    filteredList.add(object);
                }
                return filteredList;
            }
            return originalList;
        }
        return Collections.EMPTY_LIST;
    }

    protected IEditPartFilterProvider getRootEditPartFilterProvider() {
        if (this.getRoot() != null && this.getRoot().getContents() instanceof IEditPartFilterProvider) {
            return (IEditPartFilterProvider)this.getRoot().getContents();
        }
        return null;
    }
}

