/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures;

import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.FigureUtils;
import com.archimatetool.editor.diagram.figures.IContainerFigure;
import com.archimatetool.editor.diagram.util.AnimationUtil;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Color;

public abstract class AbstractContainerFigure
extends AbstractDiagramModelObjectFigure
implements IContainerFigure {
    protected static Color highlightedColor = new Color(0, 0, 255);
    protected boolean showTargetFeedback = false;
    private IFigure mainFigure;

    protected AbstractContainerFigure() {
    }

    protected AbstractContainerFigure(IDiagramModelObject diagramModelObject) {
        super(diagramModelObject);
    }

    public IFigure getMainFigure() {
        if (this.mainFigure == null) {
            this.mainFigure = new FreeformLayer();
            this.mainFigure.setLayoutManager((LayoutManager)new XYLayout());
            AnimationUtil.addFigureForAnimation(this.mainFigure);
        }
        return this.mainFigure;
    }

    @Override
    public IFigure getContentPane() {
        return this.getMainFigure();
    }

    @Override
    public void translateMousePointToRelative(Translatable t) {
        this.getContentPane().translateToRelative(t);
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    @Override
    public Dimension getDefaultSize() {
        if (this.getContentPane().getChildren().size() > 0) {
            Dimension d = new Dimension();
            for (Object child : this.getContentPane().getChildren()) {
                IFigure figure = (IFigure)child;
                Rectangle bounds = figure.getBounds();
                d.width = Math.max(bounds.x + bounds.width + 10, d.width);
                d.height = Math.max(bounds.y + bounds.height + 10, d.height);
            }
            return d.union(super.getDefaultSize());
        }
        return super.getDefaultSize();
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setAntialias(1);
        this.drawFigure(graphics);
        if (this.showTargetFeedback) {
            this.drawTargetFeedback(graphics);
        }
    }

    protected void drawTargetFeedback(Graphics graphics) {
        graphics.pushState();
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        Rectangle bounds = this.getBounds().getCopy();
        double scale = FigureUtils.getFigureScale(this);
        if (scale == 1.5) {
            --bounds.width;
            --bounds.height;
        } else if (scale < 1.0) {
            bounds.width -= 2;
            bounds.height -= 2;
        }
        bounds.shrink(1, 1);
        graphics.setForegroundColor(highlightedColor);
        graphics.setLineWidth(2);
        graphics.drawRectangle(bounds);
        graphics.popState();
    }

    @Override
    public void showTargetFeedback(boolean show) {
        if (this.showTargetFeedback != show) {
            this.showTargetFeedback = show;
            this.repaint();
        }
    }
}

