/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.figures.FigureUtils;
import com.archimatetool.editor.diagram.figures.IDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.IconicDelegate;
import com.archimatetool.editor.diagram.figures.Messages;
import com.archimatetool.editor.diagram.figures.ToolTipFigure;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.FontFactory;
import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.editor.ui.factory.IGraphicalObjectUIProvider;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Pattern;

public abstract class AbstractDiagramModelObjectFigure
extends Figure
implements IDiagramModelObjectFigure {
    boolean useLineOffset = ArchiPlugin.getInstance().getPreferenceStore().getBoolean("figureLineOffset");
    private IDiagramModelObject fDiagramModelObject;
    private Color fFillColor;
    private Color fFontColor;
    private Color fLineColor;
    private IFigureDelegate fFigureDelegate;
    private IconicDelegate fIconicDelegate;

    protected AbstractDiagramModelObjectFigure() {
    }

    protected AbstractDiagramModelObjectFigure(IDiagramModelObject diagramModelObject) {
        this.setDiagramModelObject(diagramModelObject);
    }

    @Override
    public void setDiagramModelObject(IDiagramModelObject diagramModelObject) {
        this.fDiagramModelObject = diagramModelObject;
        this.setUI();
    }

    @Override
    public IDiagramModelObject getDiagramModelObject() {
        return this.fDiagramModelObject;
    }

    public IFigureDelegate getFigureDelegate() {
        return this.fFigureDelegate;
    }

    public void setFigureDelegate(IFigureDelegate figureDelegate) {
        this.fFigureDelegate = figureDelegate;
    }

    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
        }
    }

    protected void setLineWidth(Graphics graphics, Rectangle bounds) {
        this.setLineWidth(graphics, this.getLineWidth(), bounds);
    }

    protected void setLineWidth(Graphics graphics, int lineWidth, Rectangle bounds) {
        graphics.setLineWidth(lineWidth);
        double scale = FigureUtils.getGraphicsScale(graphics);
        if (lineWidth == 1 && scale == 1.0 && !this.useLineOffset) {
            return;
        }
        bounds.width -= lineWidth;
        bounds.height -= lineWidth;
        float offset = (float)lineWidth / 2.0f;
        if (ImageFactory.getDeviceZoom() == 100 && scale == 1.0) {
            offset = (float)Math.ceil(offset);
        }
        graphics.translate(offset, offset);
    }

    protected void setDisabledState(Graphics graphics) {
    }

    protected void setLineStyle(Graphics graphics) {
        double scale = Math.min(FigureUtils.getFigureScale(this), 1.0);
        switch (this.getLineStyle()) {
            default: {
                graphics.setLineStyle(1);
                break;
            }
            case 1: {
                graphics.setLineDash(new float[]{(float)(8.0 * scale), (float)(4.0 * scale)});
                break;
            }
            case 2: {
                graphics.setLineDash(new float[]{(float)(2.0 * scale), (float)(4.0 * scale)});
            }
        }
    }

    protected abstract void setUI();

    protected void setFont() {
        this.setFont(FontFactory.getScaledFont(this.fDiagramModelObject.getFont()));
        if (this.getTextControl() != null) {
            this.getTextControl().revalidate();
        }
    }

    protected void setFillColor() {
        this.fFillColor = null;
    }

    @Override
    public Color getFillColor() {
        if (this.fFillColor == null) {
            this.fFillColor = ColorFactory.get(this.fDiagramModelObject.getFillColor());
            if (this.fFillColor == null) {
                this.fFillColor = ColorFactory.getDefaultFillColor(this.fDiagramModelObject);
            }
        }
        return this.fFillColor;
    }

    protected void setFontColor() {
        String val = this.fDiagramModelObject.getFontColor();
        Color c = ColorFactory.get(val);
        if (c == null) {
            c = ColorConstants.black;
        }
        if (c != this.fFontColor) {
            this.fFontColor = c;
            if (this.getTextControl() != null) {
                this.getTextControl().setForegroundColor(c);
            }
        }
    }

    protected void setLineColor() {
        this.fLineColor = null;
    }

    @Override
    public Color getLineColor() {
        if (this.fLineColor == null) {
            if (this.fDiagramModelObject.getDeriveElementLineColor()) {
                this.fLineColor = ColorFactory.getDerivedLineColor(this.getFillColor());
            } else {
                this.fLineColor = ColorFactory.get(this.fDiagramModelObject.getLineColor());
                if (this.fLineColor == null) {
                    this.fLineColor = ColorFactory.getDefaultLineColor(this.getDiagramModelObject());
                }
            }
        }
        return this.fLineColor;
    }

    protected int getAlpha() {
        return this.isEnabled() ? this.fDiagramModelObject.getAlpha() : Math.min(100, this.fDiagramModelObject.getAlpha());
    }

    protected int getLineAlpha() {
        return this.isEnabled() ? this.fDiagramModelObject.getLineAlpha() : 100;
    }

    protected int getGradient() {
        return this.fDiagramModelObject.getGradient();
    }

    protected int getLineWidth() {
        return this.fDiagramModelObject.getLineWidth();
    }

    protected int getLineStyle() {
        int n;
        Object object;
        IObjectUIProvider provider = ObjectUIFactory.INSTANCE.getProvider((EObject)this.getDiagramModelObject());
        if (provider != null && (object = provider.getFeatureValue("lineStyle")) instanceof Integer) {
            Integer val = (Integer)object;
            n = val;
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public void updateIconImage() {
        if (this.getIconicDelegate() != null) {
            this.getIconicDelegate().updateImage();
        }
    }

    public void drawIconImage(Graphics graphics, Rectangle drawArea) {
        if (this.hasIconImage()) {
            this.getIconicDelegate().drawIcon(graphics, drawArea);
        }
    }

    public void drawIconImage(Graphics graphics, Rectangle drawArea, int topOffset, int rightOffset, int bottomOffset, int leftOffset) {
        this.drawIconImage(graphics, drawArea, drawArea, topOffset, rightOffset, bottomOffset, leftOffset);
    }

    public void drawIconImage(Graphics graphics, Rectangle figureBounds, Rectangle drawArea, int topOffset, int rightOffset, int bottomOffset, int leftOffset) {
        if (this.hasIconImage()) {
            this.getIconicDelegate().setOffsets(topOffset, rightOffset, bottomOffset, leftOffset);
            this.getIconicDelegate().drawIcon(graphics, figureBounds, drawArea);
        }
    }

    public boolean hasIconImage() {
        return this.getIconicDelegate() != null && this.getIconicDelegate().hasImage();
    }

    public void setIconicDelegate(IconicDelegate delegate) {
        this.fIconicDelegate = delegate;
    }

    public IconicDelegate getIconicDelegate() {
        return this.fIconicDelegate;
    }

    public boolean isIconVisible() {
        switch (this.getDiagramModelObject().getIconVisibleState()) {
            case 2: {
                return false;
            }
            case 0: {
                return !this.hasIconImage();
            }
        }
        return true;
    }

    public int getIconOffset() {
        return 0;
    }

    public Color getIconColor() {
        if (!this.isEnabled()) {
            return ColorConstants.lightGray;
        }
        String val = this.fDiagramModelObject.getIconColor();
        return StringUtils.isSet(val) ? ColorFactory.get(val) : ColorConstants.black;
    }

    protected Pattern applyGradientPattern(Graphics graphics, Rectangle bounds) {
        Pattern gradient = null;
        if (this.getGradient() != -1) {
            gradient = FigureUtils.createGradient(graphics, bounds, this.getFillColor(), this.getAlpha(), FigureUtils.Direction.get(this.getGradient()));
            graphics.setBackgroundPattern(gradient);
        }
        return gradient;
    }

    protected void disposeGradientPattern(Graphics graphics, Pattern gradient) {
        if (gradient != null) {
            graphics.setBackgroundPattern(null);
            gradient.dispose();
        }
    }

    public IFigure getToolTip() {
        if (!ArchiPlugin.getInstance().getPreferenceStore().getBoolean("viewTooltips")) {
            return null;
        }
        ToolTipFigure toolTipFigure = (ToolTipFigure)super.getToolTip();
        if (toolTipFigure == null) {
            toolTipFigure = new ToolTipFigure();
            this.setToolTip((IFigure)toolTipFigure);
        }
        String text = ArchiLabelProvider.INSTANCE.getLabel(this.getDiagramModelObject());
        toolTipFigure.setText(text);
        if (this.fDiagramModelObject instanceof IDiagramModelArchimateObject) {
            IArchimateElement element = ((IDiagramModelArchimateObject)this.fDiagramModelObject).getArchimateElement();
            String type = ArchiLabelProvider.INSTANCE.getDefaultName(element.eClass());
            if (!StringUtils.isSet(text)) {
                toolTipFigure.setText(type);
            }
            toolTipFigure.setType(Messages.AbstractDiagramModelObjectFigure_0 + " " + type);
        }
        return toolTipFigure;
    }

    @Override
    public boolean didClickTextControl(Point requestLoc) {
        IFigure figure = this.getTextControl();
        if (figure != null) {
            figure.translateToRelative((Translatable)requestLoc);
            return figure.containsPoint(requestLoc);
        }
        return false;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return this.getDefaultSize();
    }

    @Override
    public Dimension getDefaultSize() {
        IGraphicalObjectUIProvider provider = (IGraphicalObjectUIProvider)ObjectUIFactory.INSTANCE.getProvider((EObject)this.getDiagramModelObject());
        return provider != null ? provider.getDefaultSize() : IGraphicalObjectUIProvider.defaultSize();
    }

    @Override
    public ConnectionAnchor getDefaultConnectionAnchor() {
        return new ChopboxAnchor((IFigure)this);
    }

    @Override
    public void dispose() {
        if (this.fIconicDelegate != null) {
            this.fIconicDelegate.dispose();
            this.fIconicDelegate = null;
        }
    }
}

