/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures;

import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.ITextFigure;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public abstract class AbstractLabelFigure
extends AbstractDiagramModelObjectFigure
implements ITextFigure {
    private Label fLabel;

    protected AbstractLabelFigure(IDiagramModelObject diagramModelObject) {
        super(diagramModelObject);
    }

    @Override
    protected void setUI() {
        this.setLayoutManager((LayoutManager)new DelegatingLayout());
        Locator labelLocator = new Locator(){

            public void relocate(IFigure target) {
                Rectangle bounds = AbstractLabelFigure.this.calculateTextControlBounds();
                if (bounds != null) {
                    AbstractLabelFigure.this.translateFromParent((Translatable)bounds);
                    target.setBounds(bounds);
                }
            }
        };
        this.add((IFigure)this.getLabel(), labelLocator);
    }

    @Override
    public void refreshVisuals() {
        this.setText();
        this.setFont();
        this.setFillColor();
        this.setFontColor();
        this.repaint();
    }

    @Override
    public void setText() {
        String text = StringUtils.safeString(this.getDiagramModelObject().getName());
        this.getLabel().setText(text);
    }

    public Label getLabel() {
        if (this.fLabel == null) {
            this.fLabel = new Label("");
        }
        return this.fLabel;
    }

    @Override
    public IFigure getTextControl() {
        return this.getLabel();
    }

    protected Rectangle calculateTextControlBounds() {
        if (this.getFigureDelegate() != null) {
            return this.getFigureDelegate().calculateTextControlBounds();
        }
        return null;
    }
}

