/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.figures.AbstractContainerFigure;
import com.archimatetool.editor.diagram.figures.ITextFigure;
import com.archimatetool.editor.diagram.figures.IconicDelegate;
import com.archimatetool.editor.diagram.figures.TextPositionDelegate;
import com.archimatetool.editor.ui.textrender.TextRenderer;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IIconic;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;

public abstract class AbstractTextControlContainerFigure
extends AbstractContainerFigure
implements ITextFigure {
    private IFigure fTextControl;
    private int fTextControlType = 0;
    public static final int TEXT_FLOW_CONTROL = 0;
    public static final int LABEL_CONTROL = 1;
    private TextPositionDelegate fTextPositionDelegate;

    protected AbstractTextControlContainerFigure(int textControlType) {
        this.fTextControlType = textControlType;
    }

    protected AbstractTextControlContainerFigure(IDiagramModelObject diagramModelObject, int textControlType) {
        this.fTextControlType = textControlType;
        this.setDiagramModelObject(diagramModelObject);
    }

    @Override
    protected void setUI() {
        this.setLayoutManager((LayoutManager)new DelegatingLayout());
        Locator textLocator = new Locator(){

            public void relocate(IFigure target) {
                Rectangle bounds = AbstractTextControlContainerFigure.this.calculateTextControlBounds();
                if (bounds == null) {
                    bounds = AbstractTextControlContainerFigure.this.getBounds().getCopy();
                }
                AbstractTextControlContainerFigure.this.translateFromParent((Translatable)bounds);
                target.setBounds(bounds);
            }
        };
        this.fTextControl = this.createTextControl(textLocator);
        Locator mainLocator = new Locator(){

            public void relocate(IFigure target) {
                Rectangle bounds = AbstractTextControlContainerFigure.this.getBounds().getCopy();
                AbstractTextControlContainerFigure.this.translateFromParent((Translatable)bounds);
                target.setBounds(bounds);
            }
        };
        this.add(this.getMainFigure(), mainLocator);
        if (this.getDiagramModelObject() instanceof IIconic) {
            this.setIconicDelegate(new IconicDelegate((IIconic)this.getDiagramModelObject()));
        }
    }

    @Override
    public void refreshVisuals() {
        this.setText();
        this.setFont();
        this.setFillColor();
        this.setFontColor();
        this.setLineColor();
        if (this.getTextControl() instanceof TextFlow) {
            int alignment = this.getDiagramModelObject().getTextAlignment();
            ((FlowPage)this.getTextControl().getParent()).setHorizontalAligment(alignment);
            if (this.fTextPositionDelegate != null) {
                this.fTextPositionDelegate.updateTextPosition();
            }
            GridLayout layout = (GridLayout)this.getTextControl().getParent().getParent().getLayoutManager();
            layout.marginWidth = this.getTextControlMarginWidth();
            layout.marginHeight = this.getTextControlMarginHeight();
        }
        this.updateIconImage();
        this.repaint();
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.getTextControl().setEnabled(value);
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().setEnabled(value);
        }
    }

    @Override
    public void setText() {
        String text = TextRenderer.getDefault().render((IArchimateModelObject)this.getDiagramModelObject(), StringUtils.safeString(this.getDiagramModelObject().getName()));
        if (this.getTextControl() instanceof TextFlow) {
            ((TextFlow)this.getTextControl()).setText(text);
        } else if (this.getTextControl() instanceof Label) {
            ((Label)this.getTextControl()).setText(text);
        }
    }

    public String getText() {
        if (this.getTextControl() instanceof TextFlow) {
            return ((TextFlow)this.getTextControl()).getText();
        }
        return ((Label)this.getTextControl()).getText();
    }

    @Override
    public IFigure getTextControl() {
        return this.fTextControl;
    }

    protected IFigure createTextControl(Locator textLocator) {
        if (this.fTextControlType == 0) {
            return this.createTextFlowControl(textLocator);
        }
        return this.createLabelControl(textLocator);
    }

    protected TextFlow createTextFlowControl(Locator textLocator) {
        TextFlow textFlow = new TextFlow();
        int wordWrapStyle = ArchiPlugin.getInstance().getPreferenceStore().getInt("archimateFigureWordWrapStyle");
        textFlow.setLayoutManager((LayoutManager)new ParagraphTextLayout(textFlow, wordWrapStyle));
        FlowPage page = new FlowPage();
        page.add((IFigure)textFlow);
        Figure textWrapperFigure = new Figure();
        GridLayout layout = new GridLayout();
        layout.marginWidth = this.getTextControlMarginWidth();
        layout.marginHeight = this.getTextControlMarginHeight();
        textWrapperFigure.setLayoutManager((LayoutManager)layout);
        textWrapperFigure.add((IFigure)page, (Object)new GridData(0x1000000, 128, true, true));
        if (this.getDiagramModelObject() instanceof ITextPosition) {
            this.fTextPositionDelegate = new TextPositionDelegate((IFigure)textWrapperFigure, (IFigure)page, (ITextPosition)this.getDiagramModelObject());
        }
        this.add((IFigure)textWrapperFigure, textLocator);
        return textFlow;
    }

    protected void setFigurePositionFromTextPosition(Rectangle rect) {
        this.setFigurePositionFromTextPosition(rect, 1.0);
    }

    protected void setFigurePositionFromTextPosition(Rectangle rect, double ratio) {
        int textPosition = ((ITextPosition)this.getDiagramModelObject()).getTextPosition();
        int textAlignment = this.getDiagramModelObject().getTextAlignment();
        Rectangle newIconPosition = rect.getCopy();
        if ((double)rect.height * ratio <= (double)rect.width) {
            newIconPosition.width = (int)((double)rect.height * ratio);
            switch (textAlignment) {
                case 2: {
                    newIconPosition.x += (rect.width - newIconPosition.width) / 2;
                    break;
                }
                case 1: {
                    newIconPosition.x += rect.width - newIconPosition.width;
                    break;
                }
            }
        } else {
            newIconPosition.height = (int)((double)rect.width / ratio);
            switch (textPosition) {
                case 0: {
                    newIconPosition.y += rect.height - newIconPosition.height;
                    break;
                }
                case 1: {
                    newIconPosition.y += (rect.height - newIconPosition.height) / 2;
                    break;
                }
            }
        }
        rect.setBounds(newIconPosition);
    }

    protected boolean shouldConstrainFigureForTextPosition(int textPosition) {
        return true;
    }

    protected Label createLabelControl(Locator textLocator) {
        Label label = new Label("");
        this.add((IFigure)label, textLocator);
        return label;
    }

    protected int getTextControlMarginWidth() {
        return 4;
    }

    protected int getTextControlMarginHeight() {
        return 4;
    }

    protected Rectangle calculateTextControlBounds() {
        Rectangle rect;
        if (this.getFigureDelegate() != null && (rect = this.getFigureDelegate().calculateTextControlBounds()) != null) {
            return rect;
        }
        if (this.getIconOffset() == 0 || !this.isIconVisible()) {
            return null;
        }
        int iconOffset = this.getIconOffset() - this.getTextControlMarginWidth();
        Rectangle rect2 = this.getBounds().getCopy();
        if (((ITextPosition)this.getDiagramModelObject()).getTextPosition() == 0) {
            int textAlignment = this.getDiagramModelObject().getTextAlignment();
            if (textAlignment == 2) {
                rect2.x += iconOffset;
                rect2.width -= iconOffset * 2;
            } else if (textAlignment == 4) {
                rect2.width -= iconOffset;
            }
        }
        return rect2;
    }
}

