/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class FigureUtils {
    public static double getFigureScale(IFigure figure) {
        if (figure instanceof ScalableFigure) {
            return ((ScalableFigure)figure).getScale();
        }
        return figure == null ? 1.0 : FigureUtils.getFigureScale(figure.getParent());
    }

    public static double getGraphicsScale(Graphics graphics) {
        if (graphics instanceof SWTGraphics) {
            return ((SWTGraphics)graphics).getScale();
        }
        if (graphics instanceof ScaledGraphics) {
            return graphics.getAbsoluteScale();
        }
        return 1.0;
    }

    public static Pattern createGradient(Graphics graphics, Device device, float x1, float y1, float x2, float y2, Color color1, int alpha1, Color color2, int alpha2) {
        double scale = graphics.getAbsoluteScale();
        return new Pattern(device, (float)((int)((double)x1 * scale)), (float)((int)((double)y1 * scale)), (float)((int)((double)x2 * scale)), (float)((int)((double)y2 * scale)), color1, alpha1, color2, alpha2);
    }

    public static Pattern createGradient(Graphics graphics, Device device, float x1, float y1, float x2, float y2, Color color1, Color color2) {
        double scale = graphics.getAbsoluteScale();
        return new Pattern(device, (float)((int)((double)x1 * scale)), (float)((int)((double)y1 * scale)), (float)((int)((double)x2 * scale)), (float)((int)((double)y2 * scale)), color1, color2);
    }

    public static Pattern createGradient(Graphics graphics, Rectangle r, Color color, Direction direction) {
        return FigureUtils.createGradient(graphics, r, color, 255, direction);
    }

    public static Pattern createGradient(Graphics graphics, Rectangle r, Color color, int alpha, Direction direction) {
        if (direction == null) {
            return null;
        }
        Color endColor = ColorConstants.white;
        float deltaFactor = 0.15f;
        switch (direction) {
            default: {
                int delta = (int)((float)r.height * deltaFactor);
                return FigureUtils.createGradient(graphics, (Device)Display.getDefault(), r.x, r.y, r.x, r.getBottom().y + delta, color, alpha, endColor, alpha);
            }
            case LEFT: {
                int delta = (int)((float)r.width * deltaFactor);
                return FigureUtils.createGradient(graphics, (Device)Display.getDefault(), r.x, r.y, r.getRight().x + delta, r.y, color, alpha, endColor, alpha);
            }
            case RIGHT: {
                int delta = (int)((float)r.width * deltaFactor);
                return FigureUtils.createGradient(graphics, (Device)Display.getDefault(), r.getRight().x, r.y, r.x - delta, r.y, color, alpha, endColor, alpha);
            }
            case BOTTOM: 
        }
        int delta = (int)((float)r.height * deltaFactor);
        return FigureUtils.createGradient(graphics, (Device)Display.getDefault(), r.x, r.getBottom().y, r.x, r.y - delta, color, alpha, endColor, alpha);
    }

    @Deprecated
    public static Pattern createGradient(Graphics graphics, Rectangle r, Color color) {
        return FigureUtils.createGradient(graphics, r, color, 255);
    }

    @Deprecated
    public static Pattern createGradient(Graphics graphics, Rectangle r, Color color, int alpha) {
        return FigureUtils.createGradient(graphics, r, color, alpha, Direction.LEFT);
    }

    public static Path createPathFromPoints(PointList points) {
        return FigureUtils.createPathFromPoints(points.toIntArray());
    }

    public static Path createPathFromPoints(int[] points) {
        Path path = new Path(null);
        path.moveTo((float)points[0], (float)points[1]);
        int i = 2;
        while (i < points.length) {
            path.lineTo((float)points[i], (float)points[i + 1]);
            i += 2;
        }
        path.lineTo((float)points[0], (float)points[1]);
        return path;
    }

    public static enum Direction {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM;


        public static Direction get(int value) {
            switch (value) {
                default: {
                    return TOP;
                }
                case 1: {
                    return LEFT;
                }
                case 2: {
                    return RIGHT;
                }
                case 3: 
            }
            return BOTTOM;
        }
    }
}

