/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures;

import com.archimatetool.editor.Logger;
import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IIconic;
import com.archimatetool.model.IProfile;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class IconicDelegate {
    public static final int MAX_IMAGESIZE = -1;
    private IIconic fIconic;
    private Image fImage;
    private int fMaxImageSize = -1;
    private String fImagePath;
    private int topOffset = 0;
    private int bottomOffset = 0;
    private int leftOffset = 0;
    private int rightOffset = 0;

    public IconicDelegate(IIconic owner) {
        this(owner, -1);
    }

    public IconicDelegate(IIconic owner, int maxSize) {
        this.fIconic = owner;
        this.fMaxImageSize = maxSize;
    }

    public void updateImage() {
        String imagePath = this.getImagePath();
        if (this.fImagePath != null && this.fImagePath.equals(imagePath)) {
            return;
        }
        this.fImagePath = imagePath;
        this.disposeImage();
        if (imagePath != null) {
            try {
                IArchiveManager archiveManager = (IArchiveManager)this.fIconic.getAdapter(IArchiveManager.class);
                if (archiveManager != null) {
                    this.fImage = archiveManager.createImage(imagePath);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Logger.logError("Could not create image!", ex);
            }
        }
    }

    public Image getImage() {
        return this.fImage;
    }

    public boolean hasImage() {
        return this.fImage != null;
    }

    private String getImagePath() {
        IDiagramModelArchimateObject dmo;
        if (this.fIconic instanceof IDiagramModelArchimateObject && (dmo = (IDiagramModelArchimateObject)this.fIconic).useProfileImage()) {
            IProfile profile = dmo.getArchimateElement().getPrimaryProfile();
            return profile != null ? profile.getImagePath() : null;
        }
        return this.fIconic != null ? this.fIconic.getImagePath() : null;
    }

    public void setTopOffset(int val) {
        this.topOffset = val;
    }

    public void setBottomOffset(int val) {
        this.bottomOffset = val;
    }

    public void setLeftOffset(int val) {
        this.leftOffset = val;
    }

    public void setRightOffset(int val) {
        this.rightOffset = val;
    }

    public void setOffsets(int top, int right, int bottom, int left) {
        this.topOffset = top;
        this.rightOffset = right;
        this.bottomOffset = bottom;
        this.leftOffset = left;
    }

    public void drawIcon(Graphics graphics, org.eclipse.draw2d.geometry.Rectangle drawArea) {
        this.drawIcon(graphics, drawArea, drawArea);
    }

    public void drawIcon(Graphics graphics, org.eclipse.draw2d.geometry.Rectangle figureBounds, org.eclipse.draw2d.geometry.Rectangle drawArea) {
        if (this.fImage == null || this.fIconic == null) {
            return;
        }
        Rectangle imageBounds = this.fImage.getBounds();
        Rectangle newSize = this.getImageSize(imageBounds);
        int width = newSize.width;
        int height = newSize.height;
        int x = drawArea.x;
        int y = drawArea.y;
        switch (this.fIconic.getImagePosition()) {
            case 0: {
                x += this.leftOffset;
                y += this.topOffset;
                break;
            }
            case 1: {
                x = drawArea.x + (drawArea.width - width) / 2;
                y += this.topOffset;
                break;
            }
            case 2: {
                x = drawArea.x + drawArea.width - width + this.rightOffset;
                y += this.topOffset;
                break;
            }
            case 3: {
                x += this.leftOffset;
                y = drawArea.y + (drawArea.height - height) / 2;
                break;
            }
            case 4: {
                x = drawArea.x + (drawArea.width - width) / 2;
                y = drawArea.y + (drawArea.height - height) / 2;
                break;
            }
            case 5: {
                x = drawArea.x + drawArea.width - width + this.rightOffset;
                y = drawArea.y + (drawArea.height - height) / 2;
                break;
            }
            case 6: {
                x += this.leftOffset;
                y = drawArea.y + drawArea.height - height + this.bottomOffset;
                break;
            }
            case 7: {
                x = drawArea.x + (drawArea.width - width) / 2;
                y = drawArea.y + drawArea.height - height + this.bottomOffset;
                break;
            }
            case 8: {
                x = drawArea.x + drawArea.width - width + this.rightOffset;
                y = drawArea.y + drawArea.height - height + this.bottomOffset;
                break;
            }
        }
        graphics.pushState();
        graphics.setAntialias(1);
        graphics.setInterpolation(2);
        graphics.setClip(figureBounds);
        graphics.setAlpha(255);
        if (this.fIconic.getImagePosition() == 9) {
            float imageRatio = (float)imageBounds.width / (float)imageBounds.height;
            float figureRatio = (float)figureBounds.width / (float)figureBounds.height;
            int newWidth = (int)(imageRatio < figureRatio ? (float)figureBounds.width : (float)figureBounds.height * imageRatio);
            int newHeight = (int)(imageRatio < figureRatio ? (float)figureBounds.width / imageRatio : (float)figureBounds.height);
            x = figureBounds.x - newWidth / 2 + figureBounds.width / 2;
            y = figureBounds.y - newHeight / 2 + figureBounds.height / 2;
            graphics.drawImage(this.fImage, 0, 0, imageBounds.width, imageBounds.height, x, y, newWidth, newHeight);
        } else if (this.fMaxImageSize == -1) {
            graphics.drawImage(this.fImage, x, y);
        } else {
            graphics.drawImage(this.fImage, 0, 0, imageBounds.width, imageBounds.height, x, y, width, height);
        }
        graphics.popState();
    }

    private Rectangle getImageSize(Rectangle imageBounds) {
        if (this.fMaxImageSize == -1) {
            return imageBounds;
        }
        return ImageFactory.getScaledImageSize(this.fImage, this.fMaxImageSize);
    }

    public void dispose() {
        this.disposeImage();
        this.fIconic = null;
    }

    private void disposeImage() {
        if (this.fImage != null && !this.fImage.isDisposed()) {
            this.fImage.dispose();
            this.fImage = null;
        }
    }
}

