/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures;

import org.eclipse.draw2d.geometry.Point;

public class PolarPoint {
    public double r;
    public double theta;

    public PolarPoint(double r, double theta) {
        this.r = r;
        this.theta = theta;
    }

    public PolarPoint(Point pole, Point point) {
        int x = point.x - pole.x;
        int y = point.y - pole.y;
        this.r = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        this.theta = Math.acos((double)x / this.r);
        if (y > 0) {
            this.theta = Math.PI * 2 - this.theta;
        }
    }

    public Point toPoint() {
        int x = (int)Math.round(this.r * Math.cos(this.theta));
        int y = (int)Math.round(-this.r * Math.sin(this.theta));
        return new Point(x, y);
    }

    public Point toAbsolutePoint(Point pole) {
        return this.toPoint().getTranslated(pole);
    }
}

