/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures;

import com.archimatetool.editor.ui.FontFactory;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.graphics.Font;

public class ToolTipFigure
extends Figure {
    private TextFlow nameText;
    private TextFlow rubricText;
    private Label typeLabel;

    public ToolTipFigure() {
        this.setBorder((Border)new MarginBorder(3));
        ToolbarLayout layout = new ToolbarLayout();
        layout.setStretchMinorAxis(false);
        this.setLayoutManager((LayoutManager)layout);
        this.nameText = this.createTextFlow();
    }

    public ToolTipFigure(String text) {
        this();
        this.setText(text);
    }

    public void setText(String text) {
        this.nameText.setText(text);
    }

    public void setType(String type) {
        if (this.typeLabel == null) {
            this.typeLabel = new Label();
            this.add((IFigure)this.typeLabel);
            this.nameText.setFont(FontFactory.SystemFontBold);
        }
        this.typeLabel.setText(type);
    }

    public void setRubric(String text) {
        if (this.rubricText == null) {
            this.rubricText = this.createTextFlow();
            this.rubricText.setFont(FontFactory.SystemFontItalic);
        }
        this.rubricText.setText(text);
    }

    private TextFlow createTextFlow() {
        final TextFlow textFlow = new TextFlow();
        textFlow.setLayoutManager((LayoutManager)new ParagraphTextLayout(textFlow, 0));
        FlowPage page = new FlowPage(){

            public Dimension getPreferredSize(int wHint, int hHint) {
                if (textFlow.getText().length() == 0) {
                    return new Dimension();
                }
                Dimension d = FigureUtilities.getTextExtents((String)textFlow.getText(), (Font)textFlow.getFont());
                if (d.width > 400) {
                    d = super.getPreferredSize(400, -1);
                }
                return d;
            }
        };
        page.add((IFigure)textFlow);
        this.add((IFigure)page);
        return textFlow;
    }
}

