/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.connections;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;

public class ArchiConnectionEndpointLocator
implements Locator {
    private boolean end;
    private Connection conn;
    private int uDistance;
    private int vDistance;
    private static Rectangle figureBounds;
    protected Transposer transposer = new Transposer();

    public ArchiConnectionEndpointLocator(Connection c, boolean isEnd) {
        this.end = isEnd;
        this.conn = c;
        this.uDistance = 14;
        this.vDistance = 4;
        figureBounds = new Rectangle();
    }

    private int calculateConnectionLocation(Point startPoint, Point endPoint) {
        if (Math.abs(endPoint.x - startPoint.x) > Math.abs(endPoint.y - startPoint.y)) {
            if (endPoint.x > startPoint.x) {
                return 2;
            }
            return 4;
        }
        if (endPoint.y > startPoint.y) {
            return 1;
        }
        return 3;
    }

    private double calculateTan(Point startPoint, Point endPoint) {
        double tan = 0.0;
        tan = endPoint.x == startPoint.x ? 1.0 : (double)(endPoint.y - startPoint.y) / (double)(endPoint.x - startPoint.x);
        if (tan > 1.0) {
            tan = 1.0;
        } else if (tan < -1.0) {
            tan = -1.0;
        }
        return tan;
    }

    private int calculateYShift(int figureWidth, int figureHeight) {
        int yShift = 0;
        if (this.vDistance < 0) {
            yShift = -figureHeight;
        } else if (this.vDistance == 0) {
            yShift = -figureHeight / 2;
        }
        return yShift;
    }

    private Connection getConnection() {
        return this.conn;
    }

    public int getUDistance() {
        return this.uDistance;
    }

    public int getVDistance() {
        return this.vDistance;
    }

    private boolean isEnd() {
        return this.end;
    }

    public void relocate(IFigure figure) {
        Connection conn = this.getConnection();
        Point startPoint = Point.SINGLETON;
        Point endPoint = new Point();
        int startPointPosition = 0;
        int endPointPosition = 1;
        if (this.isEnd()) {
            startPointPosition = conn.getPoints().size() - 1;
            endPointPosition = startPointPosition - 1;
        }
        conn.getPoints().getPoint(startPoint, startPointPosition);
        conn.getPoints().getPoint(endPoint, endPointPosition);
        int quadrant = this.calculateConnectionLocation(startPoint, endPoint);
        int cos = 1;
        this.transposer.setEnabled(false);
        if (quadrant == 1 || quadrant == 3) {
            this.transposer.setEnabled(true);
        }
        if (quadrant == 3 || quadrant == 4) {
            cos = -1;
        }
        Dimension figureSize = this.transposer.t(figure.getPreferredSize());
        startPoint = this.transposer.t(startPoint);
        endPoint = this.transposer.t(endPoint);
        double tan = this.calculateTan(startPoint, endPoint);
        int figureWidth = figureSize.width;
        int figureHeight = figureSize.height;
        int yShift = this.calculateYShift(figureWidth, figureHeight);
        Point figurePoint = new Point(startPoint.x + this.uDistance * cos + figureWidth * ((cos - 1) / 2), (int)((double)startPoint.y + (double)(cos * this.uDistance) * tan + (double)this.vDistance + (double)yShift));
        figureBounds.setSize(this.transposer.t(figureSize));
        figureBounds.setLocation(this.transposer.t(figurePoint));
        figure.setBounds(figureBounds);
    }

    public void setUDistance(int distance) {
        this.uDistance = distance;
    }

    public void setVDistance(int distance) {
        this.vDistance = distance;
    }
}

