/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.connections;

import com.archimatetool.editor.diagram.figures.PolarPoint;
import com.archimatetool.editor.diagram.figures.connections.AbstractArchimateConnectionFigure;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;

public class AssignmentConnectionFigure
extends AbstractArchimateConnectionFigure {
    private RotatableDecoration fDecoratorSource = AssignmentConnectionFigure.createFigureSourceDecoration();
    private RotatableDecoration fDecoratorTarget = AssignmentConnectionFigure.createFigureTargetDecoration();

    public static RotatableDecoration createFigureTargetDecoration() {
        return new PolygonDecoration();
    }

    public static RotatableDecoration createFigureSourceDecoration() {
        return new BallEndpoint();
    }

    @Override
    public void refreshVisuals() {
        this.setSourceDecoration(this.usePlainJunctionSourceDecoration() ? null : this.fDecoratorSource);
        this.setTargetDecoration(this.usePlainJunctionTargetDecoration() ? null : this.fDecoratorTarget);
        super.refreshVisuals();
    }

    static class BallEndpoint
    extends Figure
    implements RotatableDecoration {
        private int radius = 3;
        private Point pLocation;

        BallEndpoint() {
            this.setSize(this.radius * 2 + 1, this.radius * 2 + 1);
        }

        public void setReferencePoint(Point ref) {
            if (this.pLocation != null) {
                PolarPoint pp = new PolarPoint(ref, this.pLocation);
                pp.r -= (double)this.radius;
                super.setLocation(pp.toAbsolutePoint(ref).getTranslated(-this.radius, -this.radius));
            }
        }

        public void setLocation(Point p) {
            this.pLocation = p.getCopy();
        }

        public void paintFigure(Graphics graphics) {
            if (this.isEnabled()) {
                graphics.setBackgroundColor(this.getParent().getForegroundColor());
            } else {
                graphics.setBackgroundColor(ColorConstants.buttonDarker);
            }
            graphics.fillOval(this.bounds);
        }
    }
}

