/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.connections;

import com.archimatetool.editor.diagram.figures.FigureUtils;
import com.archimatetool.editor.diagram.figures.connections.AbstractArchimateConnectionFigure;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IInfluenceRelationship;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;

public class InfluenceConnectionFigure
extends AbstractArchimateConnectionFigure {
    private RotatableDecoration fDecoratorTarget = InfluenceConnectionFigure.createFigureTargetDecoration();

    public static RotatableDecoration createFigureTargetDecoration() {
        return new PolylineDecoration();
    }

    @Override
    protected void setFigureProperties() {
        this.setLineStyle(6);
        this.setLineDash(this.getLineDashFloats());
    }

    @Override
    public void setText() {
        super.setText();
        if (this.getModelConnection().isNameVisible()) {
            Object text = this.getConnectionLabel().getText();
            String strength = ((IInfluenceRelationship)this.getDiagramModelArchimateConnection().getArchimateRelationship()).getStrength();
            if (StringUtils.isSet(strength) && !((String)text).contains(strength)) {
                text = (String)text + " " + strength;
                this.getConnectionLabel().setText((String)text);
            }
        }
    }

    @Override
    protected float[] getLineDashFloats() {
        double scale = Math.min(FigureUtils.getFigureScale(this), 1.0);
        return new float[]{(float)(6.0 * scale), (float)(3.0 * scale)};
    }

    @Override
    public void refreshVisuals() {
        this.setTargetDecoration(this.usePlainJunctionTargetDecoration() ? null : this.fDecoratorTarget);
        super.refreshVisuals();
    }
}

