/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.connections;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.figures.PolarPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class RoundedPolylineConnection
extends PolylineConnection {
    final double CURVE_MAX_RADIUS = 14.0;
    final double JUMP_MAX_RADIUS = 5.0;
    final double MAX_ITER = 6.0;
    final double SQRT2 = Math.sqrt(2.0);
    final double PI34 = 2.356194490192345;
    final double PI2 = Math.PI * 2;
    final double PI12 = 1.5707963267948966;

    public Rectangle getBounds() {
        if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("lineJumps")) {
            return super.getBounds().getCopy().expand(10, 10);
        }
        return super.getBounds();
    }

    protected void outlineShape(Graphics g) {
        PointList bendpoints = this.getPoints();
        PointList linepoints = new PointList();
        ArrayList connections = this.getAllConnections();
        if (bendpoints.size() == 0) {
            return;
        }
        Point prev = bendpoints.getPoint(0);
        int i = 1;
        while (i < bendpoints.size()) {
            Point bp = bendpoints.getPoint(i);
            if (i == bendpoints.size() - 1) {
                this.addSegment(g, prev, bp, connections, linepoints);
            } else {
                Point next = bendpoints.getPoint(i + 1);
                if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("lineCurves")) {
                    Point bpnext;
                    Point bpprev;
                    PolarPoint prev_p = new PolarPoint(bp, prev);
                    PolarPoint next_p = new PolarPoint(bp, next);
                    double arc = next_p.theta - prev_p.theta;
                    boolean prev2next = (arc = (arc + Math.PI * 2) % (Math.PI * 2)) < Math.PI;
                    arc = prev2next ? arc : Math.PI * 2 - arc;
                    double bp_radius = 14.0;
                    bp_radius = Math.min(bp_radius, prev_p.r / 2.0);
                    bp_radius = Math.min(bp_radius, next_p.r / 2.0);
                    PolarPoint center_p = new PolarPoint(bp_radius, (prev2next ? prev_p.theta : next_p.theta) + arc / 2.0);
                    Point center = center_p.toAbsolutePoint(bp);
                    double arc_radius = bp_radius * Math.sin(arc / 2.0);
                    double start_angle = (Math.PI + arc) / 2.0 + center_p.theta;
                    double full_angle = Math.PI - arc;
                    if (!prev2next) {
                        bpprev = new PolarPoint(arc_radius, start_angle).toAbsolutePoint(center);
                        bpnext = new PolarPoint(arc_radius, start_angle + full_angle).toAbsolutePoint(center);
                    } else {
                        bpprev = new PolarPoint(arc_radius, start_angle + full_angle).toAbsolutePoint(center);
                        bpnext = new PolarPoint(arc_radius, start_angle).toAbsolutePoint(center);
                    }
                    this.addSegment(g, prev, bpprev, connections, linepoints);
                    double a = 1.0;
                    while (a < 6.0) {
                        if (prev2next) {
                            linepoints.addPoint(new PolarPoint(arc_radius, start_angle + full_angle * (1.0 - a / 6.0)).toAbsolutePoint(center));
                        } else {
                            linepoints.addPoint(new PolarPoint(arc_radius, start_angle + full_angle * a / 6.0).toAbsolutePoint(center));
                        }
                        a += 1.0;
                    }
                    prev = bpnext;
                } else {
                    this.addSegment(g, prev, bp, connections, linepoints);
                    prev = bp;
                }
            }
            ++i;
        }
        g.drawPolyline(linepoints);
    }

    private void addSegment(Graphics g, Point start, Point end, ArrayList connections, PointList linepoints) {
        ArrayList<Point> crosspoints = new ArrayList<Point>();
        int radius = 5;
        linepoints.addPoint(start);
        if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("lineJumps")) {
            PolarPoint end_p = new PolarPoint(start, end);
            double angle = end_p.theta % Math.PI;
            boolean reverse = end_p.theta != angle;
            for (RoundedPolylineConnection conn : connections) {
                PointList bendpoints = conn.getPoints();
                int j = 0;
                while (j < bendpoints.size() - 1) {
                    Point next;
                    Point bp = bendpoints.getPoint(j);
                    Point crosspoint = RoundedPolylineConnection.lineIntersect(start, end, bp, next = bendpoints.getPoint(j + 1));
                    if (crosspoint != null) {
                        PolarPoint polarPoint = new PolarPoint(crosspoint, start);
                        if (polarPoint.r > 5.0) {
                            PolarPoint polarPoint2 = new PolarPoint(crosspoint, end);
                            if (polarPoint2.r > 5.0) {
                                PolarPoint polarPoint3 = new PolarPoint(crosspoint, bp);
                                if (polarPoint3.r > 5.0) {
                                    double con_angle;
                                    PolarPoint polarPoint4 = new PolarPoint(crosspoint, next);
                                    if (polarPoint4.r > 5.0 && angle > (con_angle = new PolarPoint((Point)bp, (Point)next).theta % Math.PI) && !crosspoints.contains(crosspoint)) {
                                        crosspoints.add(crosspoint);
                                    }
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            if (crosspoints.size() != 0) {
                crosspoints.add(start);
                Collections.sort(crosspoints, new PointCompare());
                if (crosspoints.get(0) != start) {
                    Collections.reverse(crosspoints);
                }
                int i = 1;
                while (i < crosspoints.size()) {
                    double a = 0.0;
                    while (a <= 6.0) {
                        if (reverse) {
                            linepoints.addPoint(new PolarPoint(radius, angle - a * Math.PI / 6.0).toAbsolutePoint((Point)crosspoints.get(i)));
                        } else {
                            linepoints.addPoint(new PolarPoint(radius, angle - Math.PI + a * Math.PI / 6.0).toAbsolutePoint((Point)crosspoints.get(i)));
                        }
                        a += 1.0;
                    }
                    ++i;
                }
            }
        }
        linepoints.addPoint(end);
    }

    private ArrayList getAllConnections() {
        ArrayList result = new ArrayList();
        this.getAllConnections(this.getRoot(), result);
        return result;
    }

    private void getAllConnections(IFigure figure, ArrayList list) {
        for (IFigure child : figure.getChildren()) {
            if (child == this) continue;
            this.getAllConnections(child, list);
            if (!(child instanceof RoundedPolylineConnection)) continue;
            list.add(child);
        }
    }

    private IFigure getRoot() {
        RoundedPolylineConnection figure = this;
        while (figure.getParent() != null) {
            figure = figure.getParent();
        }
        return figure;
    }

    private static Point lineIntersect(Point p1, Point p2, Point p3, Point p4) {
        double denom = (p4.y - p3.y) * (p2.x - p1.x) - (p4.x - p3.x) * (p2.y - p1.y);
        if (denom == 0.0) {
            return null;
        }
        double ua = (double)((p4.x - p3.x) * (p1.y - p3.y) - (p4.y - p3.y) * (p1.x - p3.x)) / denom;
        double ub = (double)((p2.x - p1.x) * (p1.y - p3.y) - (p2.y - p1.y) * (p1.x - p3.x)) / denom;
        if (ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0) {
            Point c = new Point((int)((double)p1.x + ua * (double)(p2.x - p1.x)), (int)((double)p1.y + ua * (double)(p2.y - p1.y)));
            Rectangle r1 = new Rectangle(p1, p2);
            Rectangle r2 = new Rectangle(p3, p4);
            if (r1.contains(c) && r2.contains(c) && !c.equals(p1.x, p1.y) && !c.equals(p2.x, p2.y) && !c.equals(p3.x, p3.y) && !c.equals(p4.x, p4.y)) {
                return c;
            }
            return null;
        }
        return null;
    }

    private static class PointCompare
    implements Comparator<Point> {
        private PointCompare() {
        }

        @Override
        public int compare(Point a, Point b) {
            int delta_x = a.x - b.x;
            int delta_y = a.y - b.y;
            if (Math.abs(delta_x) > Math.abs(delta_y)) {
                return (int)Math.signum(delta_x);
            }
            return (int)Math.signum(delta_y);
        }
    }
}

