/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.diagram;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.ToolTipFigure;
import com.archimatetool.editor.diagram.figures.diagram.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.IGraphicsIcon;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IDiagramModelReference;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class DiagramModelReferenceFigure
extends AbstractTextControlContainerFigure {
    public DiagramModelReferenceFigure(IDiagramModelObject diagramModelObject) {
        super(diagramModelObject, 0);
        this.setFigureDelegate(new RectangleFigureDelegate(this));
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        super.drawFigure(graphics);
        this.drawIcon(graphics);
    }

    protected void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        IDiagramModel dm = ((IDiagramModelReference)this.getDiagramModelObject()).getReferencedModel();
        IGraphicsIcon graphicsIcon = ArchiLabelProvider.INSTANCE.getGraphicsIconForDiagramModel(dm);
        if (graphicsIcon != null) {
            graphicsIcon.drawIcon(graphics, this.getIconOrigin());
        }
    }

    protected Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 18 - this.getLineWidth(), bounds.y + 6);
    }

    @Override
    public int getIconOffset() {
        return 22;
    }

    @Override
    public IFigure getToolTip() {
        ToolTipFigure tooltip = (ToolTipFigure)super.getToolTip();
        if (tooltip == null) {
            return null;
        }
        tooltip.setType(Messages.DiagramModelReferenceFigure_0);
        return tooltip;
    }
}

