/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.diagram;

import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.FigureUtils;
import com.archimatetool.editor.diagram.figures.ITextFigure;
import com.archimatetool.editor.diagram.figures.IconicDelegate;
import com.archimatetool.editor.diagram.figures.TextPositionDelegate;
import com.archimatetool.editor.ui.textrender.TextRenderer;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IDiagramModelNote;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IIconic;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class NoteFigure
extends AbstractDiagramModelObjectFigure
implements ITextFigure {
    private TextFlow fTextFlow;
    private TextPositionDelegate fTextPositionDelegate;

    public NoteFigure(IDiagramModelNote diagramModelNote) {
        super((IDiagramModelObject)diagramModelNote);
    }

    public IDiagramModelNote getDiagramModelObject() {
        return (IDiagramModelNote)super.getDiagramModelObject();
    }

    @Override
    protected void setUI() {
        this.setLayoutManager((LayoutManager)new GridLayout());
        FlowPage page = new FlowPage();
        this.fTextFlow = new TextFlow();
        this.fTextFlow.setLayoutManager((LayoutManager)new ParagraphTextLayout(this.fTextFlow, 1));
        page.add((IFigure)this.fTextFlow);
        this.setOpaque(true);
        GridData gd = new GridData(16384, 128, true, true);
        this.add((IFigure)page, gd);
        this.fTextPositionDelegate = new TextPositionDelegate(this, (IFigure)page, (ITextPosition)this.getDiagramModelObject());
        this.setIconicDelegate(new IconicDelegate((IIconic)this.getDiagramModelObject()));
    }

    @Override
    public void refreshVisuals() {
        this.setText();
        this.setFont();
        this.setFillColor();
        this.setFontColor();
        this.setLineColor();
        ((FlowPage)this.fTextFlow.getParent()).setHorizontalAligment(this.getDiagramModelObject().getTextAlignment());
        this.fTextPositionDelegate.updateTextPosition();
        this.updateIconImage();
        this.repaint();
    }

    @Override
    public void setText() {
        String text = TextRenderer.getDefault().render((IArchimateModelObject)this.getDiagramModelObject(), this.getDiagramModelObject().getContent());
        this.fTextFlow.setText(text);
    }

    @Override
    public IFigure getTextControl() {
        return this.fTextFlow;
    }

    protected void paintFigure(Graphics graphics) {
        boolean drawBorder;
        graphics.pushState();
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        boolean bl = drawBorder = this.getDiagramModelObject().getBorderType() != 2 && this.getLineStyle() != 3;
        if (drawBorder) {
            this.setLineWidth(graphics, bounds);
            this.setLineStyle(graphics);
        }
        PointList points = new PointList();
        if (this.getDiagramModelObject().getBorderType() == 0) {
            points.addPoint(bounds.x, bounds.y);
            points.addPoint(bounds.getTopRight().x, bounds.y);
            points.addPoint(bounds.getTopRight().x, bounds.getBottomRight().y - 13);
            points.addPoint(bounds.getTopRight().x - 13, bounds.getBottomRight().y);
            points.addPoint(bounds.x, bounds.getBottomLeft().y);
        } else {
            points.addPoint(bounds.x, bounds.y);
            points.addPoint(bounds.getTopRight().x, bounds.y);
            points.addPoint(bounds.getTopRight().x, bounds.getBottomRight().y);
            points.addPoint(bounds.x, bounds.getBottomLeft().y);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        Path path = FigureUtils.createPathFromPoints(points);
        graphics.fillPath(path);
        path.dispose();
        this.disposeGradientPattern(graphics, gradient);
        this.drawIconImage(graphics, bounds);
        if (drawBorder) {
            graphics.setAlpha(this.getLineAlpha());
            graphics.setForegroundColor(this.getLineColor());
            graphics.drawPolygon(points);
        }
        graphics.popState();
    }
}

