/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import com.archimatetool.editor.ui.ColorFactory;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class ApplicationComponentFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    protected static final int INDENT = 10;
    protected IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);

    public ApplicationComponentFigure() {
        super(0);
    }

    @Override
    public void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        this.setLineWidth(graphics, bounds);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        graphics.fillRectangle(bounds.x + 10, bounds.y, bounds.width - 10, bounds.height);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        PointList points = new PointList();
        Point pt1 = new Point(bounds.x + 10, bounds.y + 10);
        points.addPoint(pt1);
        Point pt2 = new Point(pt1.x, bounds.y);
        points.addPoint(pt2);
        Point pt3 = new Point(bounds.x + bounds.width, bounds.y);
        points.addPoint(pt3);
        Point pt4 = new Point(pt3.x, bounds.y + bounds.height);
        points.addPoint(pt4);
        Point pt5 = new Point(pt1.x, pt4.y);
        points.addPoint(pt5);
        Point pt6 = new Point(pt1.x, bounds.y + 43);
        points.addPoint(pt6);
        graphics.drawPolyline(points);
        graphics.drawLine(bounds.x + 10, bounds.y + 23, bounds.x + 10, bounds.y + 30);
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(ColorFactory.getDarkerColor(this.getFillColor()));
        graphics.fillRectangle(bounds.x, bounds.y + 10, 20, 13);
        graphics.fillRectangle(bounds.x, bounds.y + 30, 20, 13);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawRectangle(bounds.x, bounds.y + 10, 20, 13);
        graphics.drawRectangle(bounds.x, bounds.y + 30, 20, 13);
        this.drawIconImage(graphics, bounds, 0, 0, 0, 20);
        graphics.popState();
    }

    protected void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        Path path = new Path(null);
        path.moveTo((float)pt.x, (float)pt.y);
        path.lineTo((float)pt.x, (float)(pt.y - 4));
        path.moveTo((float)pt.x, (float)(pt.y - 6));
        path.lineTo((float)pt.x, (float)(pt.y - 8));
        path.moveTo((float)pt.x, (float)(pt.y - 11));
        path.lineTo((float)pt.x, (float)(pt.y - 13));
        path.lineTo((float)(pt.x + 10), (float)(pt.y - 13));
        path.lineTo((float)(pt.x + 10), (float)pt.y);
        path.lineTo((float)pt.x - 0.5f, (float)pt.y);
        path.addRectangle((float)(pt.x - 3), (float)(pt.y - 11), 6.0f, 2.5f);
        path.addRectangle((float)(pt.x - 3), (float)(pt.y - 6), 6.0f, 2.5f);
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    protected Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 14 - this.getLineWidth(), bounds.y + 19);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 20 : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : null;
    }

    @Override
    protected Rectangle calculateTextControlBounds() {
        if (this.getFigureDelegate() == null) {
            Rectangle bounds = this.getBounds().getCopy();
            bounds.x += 18;
            bounds.width -= 18;
            return bounds;
        }
        return super.calculateTextControlBounds();
    }
}

