/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.model.IIconic;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class ArtifactFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private static final int FOLD_HEIGHT = 18;
    protected IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);

    public ArtifactFigure() {
        super(0);
    }

    @Override
    public void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        this.setLineWidth(graphics, rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path1 = new Path(null);
        path1.moveTo((float)rect.x, (float)rect.y);
        path1.lineTo((float)(rect.x + rect.width - 18), (float)rect.y);
        path1.lineTo((float)(rect.x + rect.width), (float)(rect.y + 18));
        path1.lineTo((float)(rect.x + rect.width), (float)(rect.y + rect.height));
        path1.lineTo((float)rect.x, (float)(rect.y + rect.height));
        path1.close();
        graphics.fillPath(path1);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setBackgroundColor(ColorFactory.getDarkerColor(this.getFillColor()));
        Path path2 = new Path(null);
        path2.moveTo((float)(rect.x + rect.width - 18), (float)rect.y);
        path2.lineTo((float)(rect.x + rect.width), (float)(rect.y + 18));
        path2.lineTo((float)(rect.x + rect.width - 18), (float)(rect.y + 18));
        graphics.fillPath(path2);
        path2.dispose();
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path1);
        path1.dispose();
        Path path3 = new Path(null);
        path3.moveTo((float)(rect.x + rect.width), (float)(rect.y + 18));
        path3.lineTo((float)(rect.x + rect.width - 18), (float)(rect.y + 18));
        path3.lineTo((float)(rect.x + rect.width - 18), (float)rect.y);
        graphics.drawPath(path3);
        path3.dispose();
        int rightOffset = ((IIconic)this.getDiagramModelObject()).getImagePosition() == 2 ? -19 : 0;
        this.drawIconImage(graphics, rect, 0, rightOffset, 0, 0);
        graphics.popState();
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        Path path = new Path(null);
        path.moveTo((float)pt.x, (float)pt.y);
        path.lineTo((float)(pt.x + 7), (float)pt.y);
        path.lineTo((float)(pt.x + 12), (float)(pt.y + 5));
        path.lineTo((float)(pt.x + 12), (float)(pt.y + 15));
        path.lineTo((float)pt.x, (float)(pt.y + 15));
        path.lineTo((float)pt.x, (float)pt.y - 0.5f);
        path.moveTo((float)(pt.x + 7), (float)pt.y);
        path.lineTo((float)(pt.x + 7), (float)(pt.y + 5));
        path.lineTo((float)(pt.x + 12), (float)(pt.y + 5));
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 15 - this.getLineWidth(), bounds.y + 6);
    }

    @Override
    public int getIconOffset() {
        return 22;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : null;
    }
}

