/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.AbstractFigureDelegate;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class BoxFigureDelegate
extends AbstractFigureDelegate {
    private static final int EDGE_SIZE = 14;

    public BoxFigureDelegate(AbstractDiagramModelObjectFigure owner) {
        super(owner);
    }

    @Override
    public void drawFigure(Graphics graphics) {
        graphics.pushState();
        Rectangle bounds = this.getBounds();
        --bounds.width;
        --bounds.height;
        this.setLineWidth(graphics, bounds);
        graphics.setAlpha(this.getAlpha());
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setBackgroundColor(ColorFactory.getDarkerColor(this.getFillColor()));
        Path path = new Path(null);
        path.moveTo((float)bounds.x, (float)(bounds.y + 14));
        path.lineTo((float)(bounds.x + 14), (float)bounds.y);
        path.lineTo((float)(bounds.x + bounds.width), (float)bounds.y);
        path.lineTo((float)(bounds.x + bounds.width), (float)(bounds.y + bounds.height - 14));
        path.lineTo((float)(bounds.x + bounds.width - 14), (float)(bounds.y + bounds.height));
        path.lineTo((float)bounds.x, (float)(bounds.y + bounds.height));
        graphics.fillPath(path);
        path.dispose();
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        graphics.fillRectangle(bounds.x, bounds.y + 14, bounds.width - 14, bounds.height - 14);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        path = new Path(null);
        path.moveTo((float)bounds.x, (float)(bounds.y + 14));
        path.lineTo((float)(bounds.x + 14), (float)bounds.y);
        path.lineTo((float)(bounds.x + bounds.width), (float)bounds.y);
        path.lineTo((float)(bounds.x + bounds.width), (float)(bounds.y + bounds.height - 14));
        path.lineTo((float)(bounds.x + bounds.width - 14), (float)(bounds.y + bounds.height));
        path.lineTo((float)bounds.x, (float)(bounds.y + bounds.height));
        path.lineTo((float)bounds.x, (float)(bounds.y + 14));
        path.lineTo((float)(bounds.x + bounds.width - 14), (float)(bounds.y + 14));
        path.lineTo((float)(bounds.x + bounds.width), (float)bounds.y);
        path.moveTo((float)(bounds.x + bounds.width - 14), (float)(bounds.y + 14));
        path.lineTo((float)(bounds.x + bounds.width - 14), (float)(bounds.y + bounds.height));
        graphics.drawPath(path);
        path.dispose();
        Rectangle imageArea = new Rectangle(bounds.x, bounds.y + 14, bounds.width - 14, bounds.height - 14);
        this.getOwner().drawIconImage(graphics, bounds, imageArea, 0, 0, 0, 0);
        graphics.popState();
    }

    @Override
    public Rectangle calculateTextControlBounds() {
        Rectangle rect = this.getBounds();
        int textPosition = ((ITextPosition)this.getOwner().getDiagramModelObject()).getTextPosition();
        int textAlignment = this.getOwner().getDiagramModelObject().getTextAlignment();
        int iconOffset = this.getOwner().isIconVisible() ? this.getOwner().getIconOffset() : 0;
        int edgeOffset = 15;
        switch (textPosition) {
            case 0: {
                rect.y += 14;
                break;
            }
            case 1: {
                rect.y += 7;
                break;
            }
        }
        switch (textAlignment) {
            case 2: {
                if (textPosition == 0) {
                    rect.x += iconOffset;
                    rect.width = rect.width - iconOffset * 2 - edgeOffset;
                    break;
                }
                rect.width -= edgeOffset;
                break;
            }
            case 4: {
                if (textPosition == 0) {
                    rect.width -= iconOffset + edgeOffset / 2;
                    break;
                }
                rect.width -= edgeOffset;
                break;
            }
        }
        return rect;
    }
}

