/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.CylinderFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;

public class BusinessRoleFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);
    private IFigureDelegate cylinderDelegate = new CylinderFigureDelegate(this);

    public BusinessRoleFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        IFigureDelegate figureDelegate = this.getFigureDelegate();
        figureDelegate.drawFigure(graphics);
        if (figureDelegate == this.rectangleDelegate) {
            this.drawIcon(graphics);
        }
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        Path path = new Path(null);
        path.addArc((float)pt.x, (float)pt.y, 5.0f, 8.0f, 90.0f, 180.0f);
        path.lineTo((float)(pt.x + 12), (float)(pt.y + 8));
        path.moveTo((float)pt.x + 2.0f, (float)pt.y);
        path.lineTo((float)(pt.x + 12), (float)pt.y);
        graphics.drawPath(path);
        path.dispose();
        graphics.drawOval(pt.x + 10, pt.y, 5, 8);
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.getRight().x - 17 - this.getLineWidth(), bounds.y + 7);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 20 : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : this.cylinderDelegate;
    }
}

