/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RoundedRectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class CapabilityFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate roundedRectangleDelegate = new RoundedRectangleFigureDelegate(this);

    public CapabilityFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = new Path(null);
        int blockLength = Math.min(rect.height / 3, rect.width / 3);
        int figureLength = blockLength * 3;
        int xMargin = (rect.width - figureLength) / 2;
        int yMargin = (rect.height - figureLength) / 2;
        path.moveTo((float)(rect.x + xMargin), (float)(rect.y + yMargin + 3 * blockLength));
        path.lineTo((float)(rect.x + xMargin), (float)(rect.y + yMargin + 2 * blockLength));
        path.lineTo((float)(rect.x + xMargin + 1 * blockLength), (float)(rect.y + yMargin + 2 * blockLength));
        path.lineTo((float)(rect.x + xMargin + 1 * blockLength), (float)(rect.y + yMargin + 1 * blockLength));
        path.lineTo((float)(rect.x + xMargin + 2 * blockLength), (float)(rect.y + yMargin + 1 * blockLength));
        path.lineTo((float)(rect.x + xMargin + 2 * blockLength), (float)(rect.y + yMargin));
        path.lineTo((float)(rect.x + xMargin + 3 * blockLength), (float)(rect.y + yMargin));
        path.lineTo((float)(rect.x + xMargin + 3 * blockLength), (float)(rect.y + yMargin + 3 * blockLength));
        path.close();
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        graphics.drawLine(rect.x + xMargin + 1 * blockLength, rect.y + yMargin + 3 * blockLength, rect.x + xMargin + 1 * blockLength, rect.y + yMargin + 2 * blockLength);
        graphics.drawLine(rect.x + xMargin + 2 * blockLength, rect.y + yMargin + 3 * blockLength, rect.x + xMargin + 2 * blockLength, rect.y + yMargin + 1 * blockLength);
        graphics.drawLine(rect.x + xMargin + 1 * blockLength, rect.y + yMargin + 2 * blockLength, rect.x + xMargin + 3 * blockLength, rect.y + yMargin + 2 * blockLength);
        graphics.drawLine(rect.x + xMargin + 2 * blockLength, rect.y + yMargin + 1 * blockLength, rect.x + xMargin + 3 * blockLength, rect.y + yMargin + 1 * blockLength);
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawRectangle(pt.x + 8, pt.y, 4, 4);
        graphics.drawRectangle(pt.x + 4, pt.y + 4, 4, 4);
        graphics.drawRectangle(pt.x + 8, pt.y + 4, 4, 4);
        graphics.drawRectangle(pt.x, pt.y + 8, 4, 4);
        graphics.drawRectangle(pt.x + 4, pt.y + 8, 4, 4);
        graphics.drawRectangle(pt.x + 8, pt.y + 8, 4, 4);
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.getRight().x - 16 - this.getLineWidth(), bounds.y + 5);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 19 : 0;
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.roundedRectangleDelegate : null;
    }
}

