/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Pattern;

public class CollaborationFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);

    public CollaborationFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        int diameter;
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect, 1.5);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        int x1 = rect.x;
        if (rect.width <= rect.height) {
            diameter = rect.width / 3 * 2;
        } else {
            diameter = Math.min(rect.height, rect.width / 3 * 2);
            x1 = (int)((double)x1 + ((double)(rect.width / 2) - (double)diameter * 0.75));
        }
        int x2 = x1 + diameter / 2;
        int y = rect.y + (rect.height - diameter) / 2;
        graphics.fillOval(x1, y, diameter, diameter);
        graphics.fillOval(x2, y, diameter, diameter);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawOval(x1, y, diameter, diameter);
        graphics.drawOval(x2, y, diameter, diameter);
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        Rectangle circle = new Rectangle(pt.x, pt.y, 10, 10);
        graphics.drawOval(circle);
        circle.translate(4, 0);
        graphics.drawOval(circle);
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 17 - this.getLineWidth(), bounds.y + 7);
    }

    @Override
    public int getIconOffset() {
        return 20;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : null;
    }
}

