/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RoundedRectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class CourseOfActionFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate roundedRectangleDelegate = new RoundedRectangleFigureDelegate(this);

    public CourseOfActionFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect, 1.24);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = new Path(null);
        int radius = this.getRadius(rect);
        Point center = this.getCenter(rect);
        path.addArc((float)center.preciseX() - (float)radius, (float)center.preciseY() - (float)radius, (float)(radius * 2), (float)(radius * 2), 0.0f, 360.0f);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        graphics.setBackgroundColor(this.getLineColor());
        int radius2 = Math.round((float)radius * 2.0f / 3.0f - (float)(graphics.getLineWidth() / 2));
        graphics.drawOval(center.x - radius2, center.y - radius2, 2 * radius2, 2 * radius2);
        int radius3 = Math.round((float)radius / 3.0f - (float)(graphics.getLineWidth() / 2));
        graphics.fillOval(center.x - radius3, center.y - radius3, 2 * radius3, 2 * radius3);
        int x = Math.round((float)center.x - (float)radius * 2.0f);
        int y = Math.round((float)center.y + (float)radius * 2.0f);
        PrecisionPoint intersection = this.getCircleIntersection(x, y, center.preciseX() - (double)radius3, center.preciseY() - (double)radius3, center.preciseX() - (double)radius3, center.preciseY() - (double)radius3, radius);
        if (intersection != null) {
            graphics.setClip(rect);
            int arrowLength = (int)((float)radius3 * 1.5f);
            int arrowLineWidth = Math.max(3, arrowLength / 5);
            graphics.setLineWidth(arrowLineWidth);
            graphics.fillPolygon(new int[]{intersection.x, intersection.y, intersection.x - arrowLength, intersection.y - arrowLength / 3, intersection.x - arrowLength / 3, intersection.y + arrowLength});
            graphics.setLineCap(2);
            graphics.drawLine(x, rect.y + rect.height, x + (intersection.x - x) / 3, intersection.y + (y - intersection.y) / 3);
            graphics.drawLine(x + (intersection.x - x) / 3, intersection.y + (y - intersection.y) / 3, intersection.x - arrowLineWidth, intersection.y + arrowLineWidth);
        }
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private int getRadius(Rectangle rect) {
        int r1 = Math.round((float)rect.height / 2.5f);
        int r2 = Math.round((float)rect.width / 3.1f);
        return Math.min(r1, r2);
    }

    private Point getCenter(Rectangle rect) {
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        int radius = this.getRadius(rect);
        int figureWidth = (int)((float)radius * 3.1f);
        int figureHeight = (int)((float)radius * 2.5f);
        return new PrecisionPoint(x + w - radius - (w - figureWidth) / 2, y + radius + (h - figureHeight) / 2);
    }

    private PrecisionPoint getCircleIntersection(double x1, double y1, double x2, double y2, double xCenter, double yCenter, double radius) {
        double baX = x2 - x1;
        double caX = xCenter - x1;
        double baY = y2 - y1;
        double caY = yCenter - y1;
        double bBy2 = baX * caX + baY * caY;
        double a = baX * baX + baY * baY;
        double pBy2 = bBy2 / a;
        double c = caX * caX + caY * caY - radius * radius;
        double q = c / a;
        double disc = pBy2 * pBy2 - q;
        if (disc >= 0.0) {
            double tmpSqrt = Math.sqrt(disc);
            double abScalingFactor1 = -pBy2 + tmpSqrt;
            double xi1 = x1 - baX * abScalingFactor1;
            double yi1 = y1 - baY * abScalingFactor1;
            return new PrecisionPoint(xi1, yi1);
        }
        return null;
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        graphics.setBackgroundColor(this.getIconColor());
        Path path = new Path(null);
        Point pt = this.getIconOrigin();
        float x = (float)pt.x - 5.4f;
        float y = (float)pt.y + 9.0f;
        path.moveTo(x, y);
        path.lineTo(x + 6.0f, y + 1.0f);
        path.lineTo(x + 3.0f, y + 6.2f);
        graphics.fillPath(path);
        path.dispose();
        path = new Path(null);
        graphics.setLineWidthFloat(2.0f);
        path.addArc((float)pt.x - 7.5f, (float)pt.y + 12.0f, 10.0f, 10.0f, 90.0f, 80.0f);
        graphics.drawPath(path);
        path.dispose();
        graphics.setLineWidthFloat(1.2f);
        path = new Path(null);
        pt = this.getIconOrigin();
        path.addArc((float)pt.x, (float)pt.y, 13.0f, 13.0f, 0.0f, 360.0f);
        path.addArc((float)pt.x + 2.5f, (float)pt.y + 2.5f, 8.0f, 8.0f, 0.0f, 360.0f);
        path.addArc((float)pt.x + 5.0f, (float)pt.y + 5.0f, 3.0f, 3.0f, 0.0f, 360.0f);
        path.addArc((float)pt.x + 6.0f, (float)pt.y + 6.0f, 1.0f, 1.0f, 0.0f, 360.0f);
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.getRight().x - 16 - this.getLineWidth(), bounds.y + 2 + this.getLineWidth());
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 25 : 0;
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.roundedRectangleDelegate : null;
    }
}

