/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.AbstractFigureDelegate;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class CylinderFigureDelegate
extends AbstractFigureDelegate {
    private final int OFFSET = 4;

    public CylinderFigureDelegate(AbstractDiagramModelObjectFigure owner) {
        super(owner);
    }

    @Override
    public void drawFigure(Graphics graphics) {
        graphics.pushState();
        Rectangle rect = this.getBounds();
        --rect.width;
        --rect.height;
        this.setLineWidth(graphics, rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = new Path(null);
        path.addArc((float)rect.x, (float)rect.y, (float)(rect.width / 4), (float)rect.height, 90.0f, 180.0f);
        path.lineTo((float)(rect.x + rect.width - rect.width / 4 * 2), (float)(rect.y + rect.height));
        path.addArc((float)(rect.x + rect.width - rect.width / 4), (float)rect.y, (float)(rect.width / 4), (float)rect.height, 270.0f, 180.0f);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        graphics.drawLine(rect.x + rect.width / 4 / 2, rect.y, rect.x + rect.width - rect.width / 4 / 2, rect.y);
        graphics.drawArc(rect.x + rect.width - rect.width / 4, rect.y, rect.width / 4, rect.height, 90, 180);
        this.getOwner().drawIconImage(graphics, rect, 0, 0, 0, 0);
        graphics.popState();
    }
}

