/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class DeliverableFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);

    public DeliverableFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        this.setLineWidth(graphics, bounds);
        graphics.setAlpha(this.getAlpha());
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        Path path = this.getFigurePath(8.0f, bounds, (float)this.getLineWidth() / 2.0f);
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        this.drawIconImage(graphics, bounds, 0, 0, -14, 0);
        graphics.popState();
    }

    protected Path getFigurePath(float curveHeight, Rectangle rect, float lineOffset) {
        float curveY = (float)rect.bottom() - curveHeight;
        Path path = new Path(null);
        path.moveTo((float)rect.x, (float)rect.y);
        path.lineTo((float)rect.x, curveY - 1.0f);
        path.quadTo((float)(rect.x + rect.width / 4), (float)rect.bottom() + curveHeight, (float)(rect.x + rect.width / 2 + 1), curveY);
        path.quadTo((float)(rect.right() - rect.width / 4), curveY - curveHeight - 1.0f, (float)rect.right(), curveY);
        path.lineTo((float)(rect.x + rect.width), (float)rect.y);
        path.lineTo((float)rect.x - lineOffset, (float)rect.y);
        return path;
    }

    protected void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        Rectangle rect = new Rectangle(pt.x, pt.y, 14, 10);
        Path path = this.getFigurePath(1.5f, rect, 0.5f);
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    protected Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 17 - this.getLineWidth(), bounds.y + 6);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 21 : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : null;
    }
}

