/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import com.archimatetool.editor.ui.ColorFactory;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class DeviceFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    protected static final int INDENT = 15;
    protected IFigureDelegate figureDelegate = new RectangleFigureDelegate(this);

    public DeviceFigure() {
        super(0);
    }

    @Override
    public void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        this.setLineWidth(graphics, bounds);
        int height_indent = bounds.height / 6;
        graphics.setAlpha(this.getAlpha());
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setBackgroundColor(ColorFactory.getDarkerColor(this.getFillColor()));
        Path path = new Path(null);
        path.moveTo((float)bounds.x, (float)(bounds.y + bounds.height));
        path.lineTo((float)(bounds.x + 15 + 1), (float)(bounds.y + bounds.height - height_indent));
        path.lineTo((float)(bounds.x + bounds.width - 15), (float)(bounds.y + bounds.height - height_indent));
        path.lineTo((float)(bounds.x + bounds.width), (float)(bounds.y + bounds.height));
        path.lineTo((float)bounds.x, (float)(bounds.y + bounds.height));
        graphics.fillPath(path);
        path.dispose();
        graphics.setForegroundColor(this.getLineColor());
        graphics.setAlpha(this.getLineAlpha());
        graphics.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y + bounds.height);
        graphics.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + 15 + 1, bounds.y + bounds.height - height_indent);
        graphics.drawLine(bounds.x + bounds.width, bounds.y + bounds.height, bounds.x + bounds.width - 15 + 1, bounds.y + bounds.height - height_indent);
        Rectangle rect = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height - height_indent);
        graphics.setBackgroundColor(this.getFillColor());
        graphics.setAlpha(this.getAlpha());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        graphics.fillRoundRectangle(rect, 30, 30);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setForegroundColor(this.getLineColor());
        graphics.setAlpha(this.getLineAlpha());
        rect = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height - height_indent);
        graphics.drawRoundRectangle(rect, 30, 30);
        Rectangle imageArea = new Rectangle(bounds.x + 3, bounds.y + 3, bounds.width - 6, bounds.height - height_indent - 6);
        this.drawIconImage(graphics, bounds, imageArea, 0, 0, 0, 0);
        graphics.popState();
    }

    protected void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawRoundRectangle(new Rectangle(pt.x, pt.y, 11, 8), 3, 3);
        graphics.drawPolygon(new int[]{pt.x - 1, pt.y + 12, pt.x + 2, pt.y + 8, pt.x + 9, pt.y + 8, pt.x + 12, pt.y + 12});
        graphics.popState();
    }

    protected Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 15 - this.getLineWidth(), bounds.y + 5);
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.figureDelegate : null;
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 20 : 0;
    }
}

