/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.elements.AbstractMotivationFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class DriverFigure
extends AbstractMotivationFigure {
    private static final double BOTTOMLEFT_ANGLE_RADIAN = Math.toRadians(135.0);
    private static final double BOTTOMRIGHT_ANGLE_RADIAN = Math.toRadians(45.0);
    private static final double TOPLEFT_ANGLE_RADIAN = Math.toRadians(225.0);
    private static final double TOPRIGHT_ANGLE_RADIAN = Math.toRadians(315.0);

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getDiagramModelArchimateObject().getType() == 0) {
            super.drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        Rectangle imageBounds = rect.getCopy();
        int lineWidth = (int)(Math.sqrt(rect.width * rect.height) / 20.0);
        graphics.setLineWidth(lineWidth);
        this.setFigurePositionFromTextPosition(rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = new Path(null);
        int radius = this.getRadius(rect);
        int actualRadius = this.getRadius(rect) - Math.round((float)radius / 10.0f) - lineWidth / 2;
        Point center = rect.getCenter();
        path.addArc((float)center.preciseX() - (float)actualRadius, (float)center.preciseY() - (float)actualRadius, (float)(actualRadius * 2), (float)(actualRadius * 2), 0.0f, 360.0f);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        graphics.setLineWidth(1);
        int topLeftX = (int)Math.round((double)center.x + (double)radius * Math.cos(TOPLEFT_ANGLE_RADIAN));
        int topLeftY = (int)Math.round((double)center.y + (double)radius * Math.sin(TOPLEFT_ANGLE_RADIAN));
        int bottomRightX = (int)Math.round((double)center.x + (double)radius * Math.cos(BOTTOMRIGHT_ANGLE_RADIAN));
        int bottomRightY = (int)Math.round((double)center.y + (double)radius * Math.sin(BOTTOMRIGHT_ANGLE_RADIAN));
        graphics.drawLine(topLeftX, topLeftY, bottomRightX, bottomRightY);
        graphics.drawLine(center.x - radius, center.y, center.x + radius, center.y);
        int bottomLeftX = (int)Math.round((double)center.x + (double)radius * Math.cos(BOTTOMLEFT_ANGLE_RADIAN));
        int bottomLeftY = (int)Math.round((double)center.y + (double)radius * Math.sin(BOTTOMLEFT_ANGLE_RADIAN));
        int topRightX = (int)Math.round((double)center.x + (double)radius * Math.cos(TOPRIGHT_ANGLE_RADIAN));
        int topRightY = (int)Math.round((double)center.y + (double)radius * Math.sin(TOPRIGHT_ANGLE_RADIAN));
        graphics.drawLine(bottomLeftX, bottomLeftY, topRightX, topRightY);
        graphics.drawLine(center.x, center.y - radius, center.x, center.y + radius);
        graphics.setBackgroundColor(this.getLineColor());
        radius = Math.round((float)radius / 4.0f);
        graphics.fillOval(center.x - radius, center.y - radius, 2 * radius, 2 * radius);
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private int getRadius(Rectangle rect) {
        int r1 = rect.height / 2;
        int r2 = rect.width / 2;
        int radius = Math.min(r1, r2);
        return radius - radius % 2;
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        graphics.setBackgroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        Path path = new Path(null);
        graphics.setLineWidthFloat(1.2f);
        path.addArc((float)pt.x, (float)pt.y, 13.0f, 13.0f, 0.0f, 360.0f);
        path.addArc((float)pt.x + 5.0f, (float)pt.y + 5.0f, 3.0f, 3.0f, 0.0f, 360.0f);
        path.addArc((float)pt.x + 6.0f, (float)pt.y + 6.0f, 1.0f, 1.0f, 0.0f, 360.0f);
        graphics.drawPath(path);
        path.dispose();
        graphics.setLineWidth(1);
        path = new Path(null);
        path.moveTo((float)(pt.x - 2), (float)pt.y + 6.5f);
        path.lineTo((float)(pt.x + 15), (float)pt.y + 6.5f);
        path.moveTo((float)pt.x + 6.5f, (float)(pt.y - 2));
        path.lineTo((float)pt.x + 6.5f, (float)(pt.y + 15));
        path.moveTo((float)pt.x + 0.5f, (float)pt.y + 0.5f);
        path.lineTo((float)pt.x + 12.5f, (float)pt.y + 12.5f);
        path.moveTo((float)pt.x + 0.5f, (float)pt.y + 12.5f);
        path.lineTo((float)pt.x + 12.5f, (float)pt.y + 0.5f);
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 20 - this.getLineWidth(), bounds.y + 6);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 23 : 0;
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }
}

