/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.editparts.RoundedRectangleAnchor;
import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RoundedRectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import com.archimatetool.model.IIconic;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class FunctionFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate roundedRectangleDelegate = new RoundedRectangleFigureDelegate(this);
    private final int OFFSET = 5;

    public FunctionFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        this.setLineWidth(graphics, rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = this.getFigurePath(rect);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setForegroundColor(this.getLineColor());
        graphics.setAlpha(this.getLineAlpha());
        graphics.drawPath(path);
        path.dispose();
        int top = 0;
        int right = 0;
        int left = 0;
        int bottom = 0;
        switch (((IIconic)this.getDiagramModelObject()).getImagePosition()) {
            case 0: 
            case 2: {
                top = rect.height / 5;
                break;
            }
            case 7: {
                bottom = -(rect.height / 5);
                break;
            }
            case 6: 
            case 8: {
                bottom = -(rect.height / 5 / 3);
            }
        }
        this.drawIconImage(graphics, rect, top, right, bottom, left);
        graphics.popState();
    }

    private Path getFigurePath(Rectangle rect) {
        Path path = new Path(null);
        float y1 = rect.y + rect.height / 5;
        float y2 = rect.y + rect.height - rect.height / 5;
        path.moveTo((float)rect.x, (float)(rect.y + rect.height));
        path.lineTo((float)rect.x, y1);
        path.lineTo((float)(rect.x + rect.width / 2), (float)rect.y);
        path.lineTo((float)(rect.x + rect.width), y1);
        path.lineTo((float)(rect.x + rect.width), (float)(rect.y + rect.height));
        path.lineTo((float)(rect.x + rect.width / 2), y2);
        path.close();
        return path;
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        PointList points = new PointList();
        Point pt = this.getIconOrigin();
        points.addPoint(pt);
        pt.translate(0, -9);
        points.addPoint(pt);
        pt.translate(6, -5);
        points.addPoint(pt);
        pt.translate(6, 5);
        points.addPoint(pt);
        pt.translate(0, 9);
        points.addPoint(pt);
        pt.translate(-6, -6);
        points.addPoint(pt);
        graphics.drawPolygon(points);
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 16 - this.getLineWidth(), bounds.y + 19);
    }

    @Override
    public ConnectionAnchor getDefaultConnectionAnchor() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? new RoundedRectangleAnchor(this) : super.getDefaultConnectionAnchor();
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 20 : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.roundedRectangleDelegate : null;
    }
}

