/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class GapFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);

    public GapFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        int widthFraction;
        if (this.getDiagramModelArchimateObject().getType() == 0) {
            super.drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect, 1.6666666666666667);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        int circleRadius = widthFraction = 3 * (rect.width / 10);
        if (rect.height < rect.width) {
            circleRadius = Math.min(rect.height / 2, widthFraction);
        }
        int xCenter = rect.x + rect.width / 2;
        int yCenter = rect.y + rect.height / 2;
        Path path = new Path(null);
        path.addArc((float)(xCenter - circleRadius), (float)(yCenter - circleRadius), (float)(circleRadius * 2), (float)(circleRadius * 2), 0.0f, 360.0f);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        graphics.drawLine(xCenter - (circleRadius + circleRadius / 2), yCenter - circleRadius / 4, xCenter + (circleRadius + circleRadius / 2), yCenter - circleRadius / 4);
        graphics.drawLine(xCenter - (circleRadius + circleRadius / 2), yCenter + circleRadius / 4, xCenter + (circleRadius + circleRadius / 2), yCenter + circleRadius / 4);
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawOval(pt.x, pt.y, 13, 13);
        pt.translate(-2, 5);
        graphics.drawLine(pt.x, pt.y, pt.x + 17, pt.y);
        pt.translate(0, 3);
        graphics.drawLine(pt.x, pt.y, pt.x + 17, pt.y);
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 17 - this.getLineWidth(), bounds.y + 6);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 23 : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : null;
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }
}

