/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.elements.AbstractMotivationFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class GoalFigure
extends AbstractMotivationFigure {
    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getDiagramModelArchimateObject().getType() == 0) {
            super.drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = new Path(null);
        int radius = this.getRadius(rect);
        Point center = rect.getCenter();
        path.addArc((float)center.preciseX() - (float)radius, (float)center.preciseY() - (float)radius, (float)(radius * 2), (float)(radius * 2), 0.0f, 360.0f);
        path.close();
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        graphics.setBackgroundColor(this.getLineColor());
        radius = Math.round((float)radius * 2.0f / 3.0f - (float)(graphics.getLineWidth() / 2));
        graphics.drawOval(center.x - radius, center.y - radius, 2 * radius, 2 * radius);
        radius = Math.round((float)radius / 3.0f - (float)(graphics.getLineWidth() / 2));
        graphics.fillOval(center.x - radius, center.y - radius, 2 * radius, 2 * radius);
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private int getRadius(Rectangle rect) {
        int r1 = rect.height / 2;
        int r2 = rect.width / 2;
        int radius = Math.min(r1, r2);
        return radius - radius % 2;
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        graphics.setBackgroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        Path path = new Path(null);
        graphics.setLineWidthFloat(1.2f);
        path.addArc((float)pt.x, (float)pt.y, 13.0f, 13.0f, 0.0f, 360.0f);
        path.addArc((float)pt.x + 2.5f, (float)pt.y + 2.5f, 8.0f, 8.0f, 0.0f, 360.0f);
        path.addArc((float)pt.x + 5.0f, (float)pt.y + 5.0f, 3.0f, 3.0f, 0.0f, 360.0f);
        path.addArc((float)pt.x + 6.0f, (float)pt.y + 6.0f, 1.0f, 1.0f, 0.0f, 360.0f);
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 19 - this.getLineWidth(), bounds.y + 6);
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 22 : 0;
    }
}

