/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.editparts.RoundedRectangleAnchor;
import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RoundedRectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class InteractionFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate roundedRectangleDelegate = new RoundedRectangleFigureDelegate(this);

    public InteractionFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect, 1.1627906976744187);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = this.getFigurePath(rect);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private Path getFigurePath(Rectangle rect) {
        int x2;
        float diameter;
        int x1 = rect.x;
        if (rect.width <= rect.height) {
            diameter = (float)rect.width * 0.86f;
            x2 = rect.x + rect.width;
        } else {
            diameter = Math.min((float)rect.height, (float)rect.width * 0.85f);
            x1 = (int)((float)x1 + (((float)rect.width - diameter) / 2.0f - diameter * 0.13999999f / 2.0f));
            x2 = (int)((float)x1 + diameter + diameter * 0.13999999f);
        }
        int y = (int)((float)rect.y + ((float)rect.height - diameter) / 2.0f);
        Path path = new Path(null);
        path.addArc((float)x1, (float)y, diameter, diameter, 90.0f, 180.0f);
        path.close();
        path.moveTo((float)x1 + diameter / 2.0f, (float)y);
        path.addArc((float)x2 - diameter, (float)y, diameter, diameter, 270.0f, 180.0f);
        path.close();
        return path;
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        Path path = new Path(null);
        path.addArc((float)(pt.x - 5), (float)pt.y, 10.0f, 12.0f, 90.0f, 180.0f);
        path.lineTo((float)pt.x, (float)pt.y - 0.5f);
        graphics.drawPath(path);
        path.dispose();
        path = new Path(null);
        path.addArc((float)(pt.x - 2), (float)pt.y, 10.0f, 12.0f, -90.0f, 180.0f);
        path.lineTo((float)(pt.x + 3), (float)pt.y + 12.5f);
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 11 - this.getLineWidth(), bounds.y + 6);
    }

    @Override
    public ConnectionAnchor getDefaultConnectionAnchor() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? new RoundedRectangleAnchor(this) : super.getDefaultConnectionAnchor();
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 20 : 0;
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.roundedRectangleDelegate : null;
    }
}

