/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Pattern;

public class ObjectFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    protected static final int TOP_MARGIN = 12;
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);
    private IFigureDelegate objectDelegate = new ObjectFigureDelegate(this);

    public ObjectFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        super.drawFigure(graphics);
        int type = this.getDiagramModelArchimateObject().getType();
        if (type == 0) {
            this.drawIcon(graphics);
        }
    }

    protected void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawRectangle(pt.x, pt.y, 13, 10);
        graphics.drawLine(pt.x, pt.y + 3, pt.x + 13, pt.y + 3);
        graphics.popState();
    }

    protected Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 17 - this.getLineWidth(), bounds.y + 6);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 20 : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : this.objectDelegate;
    }

    class ObjectFigureDelegate
    extends RectangleFigureDelegate {
        ObjectFigureDelegate(AbstractDiagramModelObjectFigure owner) {
            super(owner);
        }

        @Override
        public void drawFigure(Graphics graphics) {
            graphics.pushState();
            Rectangle bounds = this.getBounds();
            --bounds.width;
            --bounds.height;
            this.setLineWidth(graphics, bounds);
            graphics.setAlpha(this.getAlpha());
            if (!this.isEnabled()) {
                this.setDisabledState(graphics);
            }
            graphics.setBackgroundColor(this.getFillColor());
            Pattern gradient = this.applyGradientPattern(graphics, bounds);
            graphics.fillRectangle(bounds);
            this.disposeGradientPattern(graphics, gradient);
            graphics.setForegroundColor(this.getLineColor());
            graphics.setAlpha(this.getLineAlpha());
            graphics.drawLine(bounds.x, bounds.y + 12, bounds.x + bounds.width, bounds.y + 12);
            graphics.drawRectangle(bounds);
            this.getOwner().drawIconImage(graphics, bounds, 12, 0, 0, 0);
            graphics.popState();
        }

        @Override
        public Rectangle calculateTextControlBounds() {
            Rectangle bounds = this.getBounds();
            int textPosition = ((ITextPosition)ObjectFigure.this.getDiagramModelObject()).getTextPosition();
            if (textPosition == 0) {
                bounds.y += 12 - ObjectFigure.this.getTextControlMarginHeight();
            }
            return bounds;
        }
    }
}

