/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.elements.AbstractMotivationFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class OutcomeFigure
extends AbstractMotivationFigure {
    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getDiagramModelArchimateObject().getType() == 0) {
            super.drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = new Path(null);
        int radius = this.getRadius(rect);
        Point center = this.getCenter(rect);
        path.addArc((float)center.preciseX() - (float)radius, (float)center.preciseY() - (float)radius, (float)(radius * 2), (float)(radius * 2), 0.0f, 360.0f);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        graphics.setBackgroundColor(this.getLineColor());
        int radius2 = Math.round((float)radius * 2.0f / 3.0f - (float)(graphics.getLineWidth() / 2));
        graphics.drawOval(center.x - radius2, center.y - radius2, 2 * radius2, 2 * radius2);
        int radius3 = Math.round((float)radius / 3.0f - (float)(graphics.getLineWidth() / 2));
        graphics.drawOval(center.x - radius3, center.y - radius3, 2 * radius3, 2 * radius3);
        int arrowLength = (int)((float)radius3 * 0.8f);
        int arrowLineWidth = Math.max(2, arrowLength / 6);
        Rectangle rectTemp = rect.getCopy();
        --rectTemp.width;
        Point centerTemp = this.getCenter(rectTemp);
        graphics.fillPolygon(new int[]{centerTemp.x - arrowLineWidth, centerTemp.y + arrowLineWidth, centerTemp.x + arrowLength, centerTemp.y, centerTemp.x, centerTemp.y - arrowLength});
        graphics.setLineWidth(arrowLineWidth);
        double ratio = 1.2;
        graphics.drawLine(center.x, center.y, (int)((double)center.x + (double)radius * ratio - 0.5 * (double)arrowLength), (int)((double)center.y - (double)radius * ratio + 0.5 * (double)arrowLength));
        graphics.drawLine((int)((double)center.x + ratio * ((double)radius - (double)arrowLength * 1.2)), (int)((double)center.y + ratio * ((double)arrowLength * 1.2 - (double)radius)), (int)((double)center.x + (double)radius * ratio), (int)((double)center.y - (double)radius * ratio) + arrowLength + arrowLineWidth);
        graphics.drawLine((int)((double)center.x + ratio * ((double)radius - (double)arrowLength * 1.2)), (int)((double)center.y + ratio * ((double)arrowLength * 1.2 - (double)radius)), (int)((double)center.x + (double)radius * ratio) - arrowLength - arrowLineWidth, (int)((double)center.y - (double)radius * ratio));
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private Point getCenter(Rectangle rect) {
        int radius = this.getRadius(rect);
        int figureWidth = (int)((float)radius * 2.2f);
        int figureHeight = (int)((float)radius * 2.2f);
        return new PrecisionPoint(rect.x + radius + (rect.width - figureWidth) / 2, rect.y + rect.height - radius - (rect.height - figureHeight) / 2);
    }

    private int getRadius(Rectangle rect) {
        int r1 = Math.round((float)rect.height / 2.2f);
        int r2 = Math.round((float)rect.width / 2.2f);
        return Math.min(r1, r2);
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        graphics.setBackgroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        Path path = new Path(null);
        graphics.setLineWidthFloat(1.2f);
        path.addArc((float)pt.x, (float)pt.y, 13.0f, 13.0f, 0.0f, 360.0f);
        path.addArc((float)pt.x + 2.5f, (float)pt.y + 2.5f, 8.0f, 8.0f, 0.0f, 360.0f);
        path.addArc((float)pt.x + 5.0f, (float)pt.y + 5.0f, 3.0f, 3.0f, 0.0f, 360.0f);
        path.addArc((float)pt.x + 6.0f, (float)pt.y + 6.0f, 1.0f, 1.0f, 0.0f, 360.0f);
        graphics.drawPath(path);
        path.dispose();
        graphics.setLineWidth(1);
        path = new Path(null);
        path.moveTo((float)pt.x + 6.0f, (float)pt.y + 7.0f);
        path.lineTo((float)pt.x + 15.5f, (float)pt.y - 2.5f);
        path.moveTo((float)pt.x + 13.0f, (float)pt.y + 0.0f);
        path.lineTo((float)pt.x + 14.0f, (float)pt.y - 5.0f);
        path.moveTo((float)pt.x + 13.0f, (float)pt.y + 0.0f);
        path.lineTo((float)pt.x + 18.0f, (float)pt.y - 1.0f);
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 24 - this.getLineWidth(), bounds.y + 9);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 27 : 0;
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }
}

