/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.AbstractFigureDelegate;
import com.archimatetool.editor.diagram.figures.FigureUtils;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class ParallelogramFigureDelegate
extends AbstractFigureDelegate {
    protected static final int FLANGE = 16;
    protected static final int TEXT_INDENT = 20;
    protected boolean fWithSlash;

    public ParallelogramFigureDelegate(AbstractDiagramModelObjectFigure owner, boolean withSlash) {
        super(owner);
        this.fWithSlash = withSlash;
    }

    @Override
    public void drawFigure(Graphics graphics) {
        graphics.pushState();
        Rectangle bounds = this.getBounds();
        --bounds.width;
        --bounds.height;
        this.setLineWidth(graphics, bounds);
        PointList points = new PointList();
        points.addPoint(bounds.x + 16, bounds.y);
        points.addPoint(bounds.x + bounds.width, bounds.y);
        points.addPoint(bounds.x + bounds.width - 16, bounds.y + bounds.height);
        points.addPoint(bounds.x, bounds.y + bounds.height);
        graphics.setAlpha(this.getAlpha());
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        Path path = FigureUtils.createPathFromPoints(points);
        graphics.fillPath(path);
        path.dispose();
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPolygon(points);
        if (this.fWithSlash) {
            graphics.drawLine(bounds.x + 16 + 20, bounds.y, bounds.x + 20, bounds.y + bounds.height);
        }
        this.getOwner().drawIconImage(graphics, bounds, 0, 0, 0, 0);
        graphics.popState();
    }
}

