/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class PlateauFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);

    public PlateauFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        Rectangle imageBounds = rect.getCopy();
        this.setFigurePositionFromTextPosition(rect, 1.4285714285714286);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        int lineWidth = (int)Math.max(7.0, Math.sqrt(rect.width * rect.height) / 16.0);
        graphics.setLineWidth(lineWidth);
        int figureMaxSize = Math.min(rect.width, rect.height);
        int xMargin = (rect.width - figureMaxSize) / 2;
        int yMargin = (rect.height - figureMaxSize) / 2;
        graphics.drawLine(rect.x + xMargin, rect.y + yMargin + 3 * figureMaxSize / 4, rect.x + xMargin + figureMaxSize - 2 * figureMaxSize / 6, rect.y + yMargin + 3 * figureMaxSize / 4);
        graphics.drawLine(rect.x + xMargin + 1 * figureMaxSize / 6, rect.y + yMargin + 2 * figureMaxSize / 4, rect.x + xMargin + figureMaxSize - 1 * figureMaxSize / 6, rect.y + yMargin + 2 * figureMaxSize / 4);
        graphics.drawLine(rect.x + xMargin + 2 * figureMaxSize / 6, rect.y + yMargin + 1 * figureMaxSize / 4, rect.x + xMargin + figureMaxSize, rect.y + yMargin + 1 * figureMaxSize / 4);
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(2);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawLine(pt.x, pt.y, pt.x + 12, pt.y);
        pt.translate(2, -3);
        graphics.drawLine(pt.x, pt.y, pt.x + 12, pt.y);
        pt.translate(2, -3);
        graphics.drawLine(pt.x, pt.y, pt.x + 12, pt.y);
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 20 - this.getLineWidth(), bounds.y + 13);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 17 : 0;
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : null;
    }
}

