/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.elements.AbstractMotivationFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class PrincipleFigure
extends AbstractMotivationFigure {
    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getDiagramModelArchimateObject().getType() == 0) {
            super.drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = new Path(null);
        int divisions = 24;
        int div1 = 8;
        int div2 = 16;
        int fractionX = rect.width / divisions;
        int fractionY = rect.height / divisions;
        int corner = Math.min(fractionX, fractionY);
        path.moveTo((float)(rect.x + corner), (float)(rect.y + corner));
        path.cubicTo((float)(rect.x + fractionX * div1), (float)rect.y, (float)(rect.x + fractionX * div2), (float)rect.y, (float)(rect.x + rect.width - corner), (float)(rect.y + corner));
        path.cubicTo((float)(rect.x + rect.width), (float)(rect.y + fractionY * div1), (float)(rect.x + rect.width), (float)(rect.y + fractionY * div2), (float)(rect.x + rect.width - corner), (float)(rect.y + rect.height - corner));
        path.cubicTo((float)(rect.x + fractionX * div2), (float)(rect.y + rect.height), (float)(rect.x + fractionX * div1), (float)(rect.y + rect.height), (float)(rect.x + corner), (float)(rect.y + rect.height - corner));
        path.cubicTo((float)rect.x, (float)(rect.y + fractionY * div2), (float)rect.x, (float)(rect.y + fractionY * div1), (float)(rect.x + corner), (float)(rect.y + corner));
        path.close();
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        graphics.setBackgroundColor(this.getLineColor());
        Point center = rect.getCenter();
        int width = Math.max(1, Math.round(((float)rect.height - 2.0f * (float)graphics.getLineWidth()) / 20.0f));
        if (width >= rect.width / 2) {
            width = Math.max(1, rect.width / 4);
        }
        graphics.fillPolygon(new int[]{center.x - Math.round(width), rect.y + 3 * width, center.x + Math.round(width), rect.y + 3 * width, center.x + Math.round(0.8f * (float)width), rect.y + rect.height - 7 * width, center.x - Math.round(0.8f * (float)width), rect.y + rect.height - 7 * width});
        graphics.fillPolygon(new int[]{center.x + Math.round(0.8f * (float)width), rect.y + rect.height - 5 * width, center.x - Math.round(0.8f * (float)width), rect.y + rect.height - 5 * width, center.x - Math.round(0.8f * (float)width), rect.y + rect.height - 3 * width, center.x + Math.round(0.8f * (float)width), rect.y + rect.height - 3 * width});
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        graphics.setBackgroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawRoundRectangle(new Rectangle(pt.x, pt.y, 12, 14), 4, 4);
        Path path = new Path(null);
        path.moveTo((float)pt.x + 5.5f, (float)(pt.y + 2));
        path.lineTo((float)pt.x + 5.5f, (float)(pt.y + 9));
        path.moveTo((float)pt.x + 6.5f, (float)(pt.y + 2));
        path.lineTo((float)pt.x + 6.5f, (float)(pt.y + 9));
        path.moveTo((float)pt.x + 5.5f, (float)pt.y + 10.5f);
        path.lineTo((float)pt.x + 5.5f, (float)pt.y + 12.5f);
        path.moveTo((float)pt.x + 6.5f, (float)pt.y + 10.5f);
        path.lineTo((float)pt.x + 6.5f, (float)pt.y + 12.5f);
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 19 - this.getLineWidth(), bounds.y + 6);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 23 : 0;
    }
}

