/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import com.archimatetool.model.IIconic;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class ProductFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    protected static final int TOP_MARGIN = 12;
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);
    private IFigureDelegate productDelegate = new RectangleFigureDelegate(this){

        @Override
        public void drawFigure(Graphics graphics) {
            graphics.pushState();
            Rectangle bounds = this.getBounds();
            --bounds.width;
            --bounds.height;
            this.setLineWidth(graphics, bounds);
            graphics.setAlpha(this.getAlpha());
            if (!this.isEnabled()) {
                this.setDisabledState(graphics);
            }
            graphics.setBackgroundColor(this.getFillColor());
            Pattern gradient = this.applyGradientPattern(graphics, bounds);
            graphics.fillRectangle(bounds);
            this.disposeGradientPattern(graphics, gradient);
            graphics.setForegroundColor(this.getLineColor());
            graphics.setAlpha(this.getLineAlpha());
            graphics.drawRectangle(bounds);
            Path path = new Path(null);
            path.moveTo((float)bounds.x, (float)(bounds.y + 12));
            path.lineTo((float)bounds.getCenter().x, (float)(bounds.y + 12));
            path.lineTo((float)bounds.getCenter().x, (float)bounds.y);
            graphics.drawPath(path);
            path.dispose();
            int topOffset = ((IIconic)ProductFigure.this.getDiagramModelObject()).getImagePosition() == 0 ? 12 : 0;
            ProductFigure.this.drawIconImage(graphics, bounds, topOffset, 0, 0, 0);
            graphics.popState();
        }

        @Override
        public Rectangle calculateTextControlBounds() {
            Rectangle bounds = this.getBounds();
            int textPosition = ((ITextPosition)ProductFigure.this.getDiagramModelObject()).getTextPosition();
            if (textPosition == 0) {
                bounds.y += 12 - ProductFigure.this.getTextControlMarginHeight() - 1;
            }
            return bounds;
        }
    };

    public ProductFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        super.drawFigure(graphics);
        int type = this.getDiagramModelArchimateObject().getType();
        if (type == 0) {
            this.drawIcon(graphics);
        }
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawRectangle(pt.x, pt.y, 13, 10);
        graphics.drawRectangle(pt.x, pt.y, 6, 3);
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds().getCopy();
        return new Point(bounds.x + bounds.width - 17 - this.getLineWidth(), bounds.y + 6);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 20 : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : this.productDelegate;
    }
}

