/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class ResourceFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);

    public ResourceFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        this.setLineWidth(graphics, rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = this.getFigurePath(rect);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        Dimension nubSize = new Dimension(rect.width / 10, rect.height / 3);
        graphics.drawLine(rect.x + rect.width - nubSize.width, rect.y + (rect.height - nubSize.height) / 2, rect.x + rect.width - nubSize.width, rect.y + (rect.height - nubSize.height) / 2 + nubSize.height);
        int lineTop = rect.y + rect.height / 5;
        int lineBottom = rect.y + rect.height * 4 / 5;
        int lineGap = rect.width / 6;
        graphics.drawLine(rect.x + lineGap, lineTop, rect.x + lineGap, lineBottom);
        graphics.drawLine(rect.x + lineGap * 2, lineTop, rect.x + lineGap * 2, lineBottom);
        graphics.drawLine(rect.x + lineGap * 3, lineTop, rect.x + lineGap * 3, lineBottom);
        this.drawIconImage(graphics, rect, 0, 0, 0, 0);
        graphics.popState();
    }

    private Path getFigurePath(Rectangle rect) {
        Dimension nubSize = new Dimension(rect.width / 10, rect.height / 3);
        int arc1 = 5;
        int arc2 = 3;
        Path path = new Path(null);
        path.moveTo((float)(rect.x + arc1), (float)rect.y);
        path.lineTo((float)(rect.x + rect.width - nubSize.width - arc1), (float)rect.y);
        path.cubicTo((float)(rect.x + rect.width - nubSize.width - arc1), (float)rect.y, (float)(rect.x + rect.width - nubSize.width), (float)rect.y, (float)(rect.x + rect.width - nubSize.width), (float)(rect.y + arc1));
        path.lineTo((float)(rect.x + rect.width - nubSize.width), (float)(rect.y + (rect.height - nubSize.height) / 2));
        path.lineTo((float)(rect.x + rect.width - arc1), (float)(rect.y + (rect.height - nubSize.height) / 2));
        path.cubicTo((float)(rect.x + rect.width - arc2), (float)(rect.y + (rect.height - nubSize.height) / 2), (float)(rect.x + rect.width), (float)(rect.y + (rect.height - nubSize.height) / 2), (float)(rect.x + rect.width), (float)(rect.y + (rect.height - nubSize.height) / 2 + arc2));
        path.lineTo((float)(rect.x + rect.width), (float)(rect.y + (rect.height - nubSize.height) / 2 + nubSize.height - arc1));
        path.cubicTo((float)(rect.x + rect.width), (float)(rect.y + (rect.height - nubSize.height) / 2 + nubSize.height - arc2), (float)(rect.x + rect.width), (float)(rect.y + (rect.height - nubSize.height) / 2 + nubSize.height), (float)(rect.x + rect.width - arc2), (float)(rect.y + (rect.height - nubSize.height) / 2 + nubSize.height));
        path.lineTo((float)(rect.x + rect.width - nubSize.width), (float)(rect.y + (rect.height - nubSize.height) / 2 + nubSize.height));
        path.lineTo((float)(rect.x + rect.width - nubSize.width), (float)(rect.y + rect.height - arc1));
        path.cubicTo((float)(rect.x + rect.width - nubSize.width), (float)(rect.y + rect.height - arc1), (float)(rect.x + rect.width - nubSize.width), (float)(rect.y + rect.height), (float)(rect.x + rect.width - nubSize.width - arc1), (float)(rect.y + rect.height));
        path.lineTo((float)(rect.x + arc1), (float)(rect.y + rect.height));
        path.cubicTo((float)(rect.x + arc1), (float)(rect.y + rect.height), (float)rect.x, (float)(rect.y + rect.height), (float)rect.x, (float)(rect.y + rect.height - arc1));
        path.lineTo((float)rect.x, (float)(rect.y + arc1));
        path.cubicTo((float)rect.x, (float)(rect.y + arc1), (float)rect.x, (float)rect.y, (float)(rect.x + arc1), (float)rect.y);
        path.close();
        return path;
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawRoundRectangle(new Rectangle(pt.x, pt.y, 15, 10), 3, 3);
        pt.translate(15, 3);
        graphics.drawRoundRectangle(new Rectangle(pt.x, pt.y, 2, 4), 1, 1);
        pt = this.getIconOrigin();
        Path path = new Path(null);
        path.moveTo((float)pt.x + 3.0f, (float)(pt.y + 2));
        path.lineTo((float)pt.x + 3.0f, (float)(pt.y + 8));
        path.moveTo((float)pt.x + 6.0f, (float)(pt.y + 2));
        path.lineTo((float)pt.x + 6.0f, (float)(pt.y + 8));
        path.moveTo((float)pt.x + 9.0f, (float)(pt.y + 2));
        path.lineTo((float)pt.x + 9.0f, (float)(pt.y + 8));
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.getRight().x - 19 - this.getLineWidth(), bounds.y + 7);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 22 : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : null;
    }
}

