/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class SystemSoftwareFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);

    public SystemSoftwareFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        graphics.setForegroundColor(this.getLineColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        int diameter = rect.width / 3 * 2;
        int x1 = rect.x + (rect.width - diameter) / 4;
        int x2 = x1 + diameter / 6;
        int y1 = rect.y + (rect.height - diameter) / 2;
        int y2 = y1 + diameter / 6;
        graphics.fillOval(x2, y1, diameter, diameter);
        graphics.setAlpha(this.getLineAlpha());
        graphics.drawOval(x2, y1, diameter, diameter);
        graphics.setAlpha(this.getAlpha());
        graphics.fillOval(x1, y2, diameter, diameter);
        graphics.setAlpha(this.getLineAlpha());
        graphics.drawOval(x1, y2, diameter, diameter);
        this.disposeGradientPattern(graphics, gradient);
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        Path path = new Path(null);
        path.addArc((float)pt.x, (float)pt.y, 11.0f, 11.0f, 90.0f, 360.0f);
        path.addArc((float)(pt.x + 2), (float)(pt.y - 2), 11.0f, 11.0f, -60.0f, 210.0f);
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds().getCopy();
        return new Point(bounds.x + bounds.width - 16 - this.getLineWidth(), bounds.y + 8);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 20 : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : null;
    }
}

