/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.elements.AbstractMotivationFigure;
import com.archimatetool.model.IIconic;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Pattern;

public class ValueFigure
extends AbstractMotivationFigure {
    @Override
    public void drawFigure(Graphics graphics) {
        if (this.getDiagramModelArchimateObject().getType() == 0) {
            super.drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        this.setLineWidth(graphics, bounds);
        graphics.setAlpha(this.getAlpha());
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        graphics.fillOval(bounds);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawOval(bounds);
        int top = 0;
        int right = 0;
        int left = 0;
        int bottom = 0;
        int offset = 6;
        switch (((IIconic)this.getDiagramModelObject()).getImagePosition()) {
            case 0: {
                top = bounds.height / offset;
                left = bounds.width / offset;
                break;
            }
            case 2: {
                top = bounds.height / offset;
                right = -(bounds.width / offset);
                break;
            }
            case 6: {
                bottom = -(bounds.height / offset);
                left = bounds.width / offset;
                break;
            }
            case 8: {
                bottom = -(bounds.height / offset);
                right = -(bounds.width / offset);
            }
        }
        this.drawIconImage(graphics, bounds, top, right, bottom, left);
        graphics.popState();
    }

    @Override
    public ConnectionAnchor getDefaultConnectionAnchor() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getDefaultConnectionAnchor() : new EllipseAnchor((IFigure)this);
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawOval(pt.x, pt.y, 14, 9);
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds().getCopy();
        return new Point(bounds.x + bounds.width - 19 - this.getLineWidth(), bounds.y + 7);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 21 : 0;
    }
}

