/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RoundedRectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import com.archimatetool.model.IIconic;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class ValueStreamFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate fMainFigureDelegate = new RoundedRectangleFigureDelegate(this);

    public ValueStreamFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        this.setLineWidth(graphics, bounds);
        int indent = Math.min(bounds.height / 2, bounds.width / 2);
        int centre_y = bounds.y + bounds.height / 2;
        int point_startx = bounds.x + bounds.width - indent;
        graphics.setAlpha(this.getAlpha());
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        Path path = new Path(null);
        path.moveTo((float)bounds.x, (float)bounds.y);
        path.lineTo((float)(bounds.x + indent), (float)centre_y);
        path.lineTo((float)bounds.x, (float)(bounds.y + bounds.height));
        path.lineTo((float)point_startx, (float)(bounds.y + bounds.height));
        path.lineTo((float)(bounds.x + bounds.width), (float)centre_y);
        path.lineTo((float)point_startx, (float)bounds.y);
        path.lineTo((float)bounds.x, (float)bounds.y);
        path.lineTo((float)(bounds.x + indent), (float)centre_y);
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        int top = 0;
        int right = 0;
        int left = 0;
        int bottom = 0;
        switch (((IIconic)this.getDiagramModelObject()).getImagePosition()) {
            case 0: 
            case 6: {
                left = 10;
                break;
            }
            case 2: 
            case 8: {
                right = -indent;
                break;
            }
            case 3: {
                left = indent;
                break;
            }
            case 5: {
                right = -10;
            }
        }
        this.drawIconImage(graphics, bounds, top, right, bottom, left);
        graphics.popState();
    }

    protected void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        PointList points = new PointList();
        Point pt = this.getIconOrigin();
        points.addPoint(pt);
        pt.translate(10, 0);
        points.addPoint(pt);
        pt.translate(5, 5);
        points.addPoint(pt);
        pt.translate(-5, 5);
        points.addPoint(pt);
        pt.translate(-10, 0);
        points.addPoint(pt);
        pt.translate(5, -5);
        points.addPoint(pt);
        graphics.drawPolygon(points);
        graphics.popState();
    }

    protected Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.getRight().x - 18 - this.getLineWidth(), bounds.y + 7);
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.fMainFigureDelegate : null;
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 25 : 0;
    }
}

