/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.editparts.RoundedRectangleAnchor;
import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RoundedRectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;

public class WorkPackageFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private RoundedRectangleFigureDelegate figureDelegate = new RoundedRectangleFigureDelegate(this);

    public WorkPackageFigure() {
        super(0);
    }

    @Override
    public ConnectionAnchor getDefaultConnectionAnchor() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? new RoundedRectangleAnchor(this) : super.getDefaultConnectionAnchor();
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        Rectangle imageBounds = rect.getCopy();
        this.setFigurePositionFromTextPosition(rect, 1.1428571428571428);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.setBackgroundColor(this.getLineColor());
        float gridUnit = (float)((double)rect.width / 8.0);
        int lineWidth = (int)gridUnit;
        graphics.setLineWidth(lineWidth);
        graphics.setLineCap(2);
        Path path = new Path(null);
        float radius = (int)(2.5f * gridUnit);
        path.addArc((float)rect.x + gridUnit / 2.0f, (float)rect.y + gridUnit / 2.0f, radius * 2.0f, radius * 2.0f, -25.0f, 295.0f);
        float[] currentPoint = new float[2];
        path.getCurrentPoint(currentPoint);
        path.lineTo(currentPoint[0] + 3.0f * gridUnit, currentPoint[1]);
        graphics.drawPath(path);
        path.getCurrentPoint(currentPoint);
        path.dispose();
        path = new Path(null);
        path.moveTo(currentPoint[0], currentPoint[1]);
        path.lineTo(currentPoint[0], currentPoint[1] - 1.5f * gridUnit);
        path.lineTo(currentPoint[0] + 2.0f * gridUnit, currentPoint[1]);
        path.lineTo(currentPoint[0], currentPoint[1] + 1.5f * gridUnit);
        path.close();
        graphics.fillPath(path);
        path.dispose();
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        graphics.setBackgroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        float circleWidth = 9.0f;
        float circleHalf = circleWidth / 2.0f;
        Path path = new Path(null);
        path.addArc((float)pt.x, (float)pt.y, circleWidth, circleWidth, 340.0f, 295.0f);
        path.moveTo((float)pt.x + circleHalf, (float)pt.y + circleWidth);
        path.lineTo((float)(pt.x + 11), (float)pt.y + circleWidth);
        graphics.drawPath(path);
        path.dispose();
        path = new Path(null);
        path.moveTo((float)(pt.x + 11), (float)pt.y + circleWidth - 3.0f);
        path.lineTo((float)(pt.x + 15), (float)pt.y + circleWidth);
        path.lineTo((float)(pt.x + 11), (float)pt.y + circleWidth + 3.0f);
        path.close();
        graphics.fillPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 17 - this.getLineWidth(), bounds.y + 6);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 19 : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.figureDelegate : null;
    }
}

