/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.policies;

import com.archimatetool.editor.diagram.ArchimateDiagramModelFactory;
import com.archimatetool.editor.diagram.commands.AddDiagramModelReferenceCommand;
import com.archimatetool.editor.diagram.commands.AddDiagramObjectCommand;
import com.archimatetool.editor.diagram.commands.CreateNestedArchimateConnectionsWithDialogCommand;
import com.archimatetool.editor.diagram.dnd.AbstractDNDEditPolicy;
import com.archimatetool.editor.diagram.dnd.DiagramDropRequest;
import com.archimatetool.editor.diagram.policies.Messages;
import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.model.commands.NonNotifyingCompoundCommand;
import com.archimatetool.editor.preferences.ConnectionPreferences;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ArchimateDNDEditPolicy
extends AbstractDNDEditPolicy {
    private List<IArchimateElement> fElementsToAdd;
    private List<IArchimateRelationship> fRelationsToAdd;
    private List<IDiagramModel> fDiagramRefsToAdd;

    @Override
    protected Command getDropCommand(DiagramDropRequest request) {
        if (!(request.getData() instanceof IStructuredSelection)) {
            return null;
        }
        Point pt = this.getDropLocation(request);
        int origin = pt.x;
        int x = pt.x;
        int y = pt.y;
        this.fElementsToAdd = new ArrayList<IArchimateElement>();
        this.fRelationsToAdd = new ArrayList<IArchimateRelationship>();
        this.fDiagramRefsToAdd = new ArrayList<IDiagramModel>();
        Object[] objects = ((IStructuredSelection)request.getData()).toArray();
        this.getElementsToAdd(objects);
        ArrayList<Object> diagramComponentsThatWereAdded = new ArrayList<Object>();
        NonNotifyingCompoundCommand result = new NonNotifyingCompoundCommand(Messages.ArchimateDNDEditPolicy_0);
        for (IArchimateElement element : this.fElementsToAdd) {
            IDiagramModelArchimateObject iDiagramModelArchimateObject = ArchimateDiagramModelFactory.createDiagramModelArchimateObject(element);
            iDiagramModelArchimateObject.getBounds().setLocation(x, y);
            diagramComponentsThatWereAdded.add(iDiagramModelArchimateObject);
            result.add(new AddDiagramObjectCommand(this.getTargetContainer(), (IDiagramModelObject)iDiagramModelArchimateObject));
            if ((x += 150) <= origin + 400) continue;
            x = origin;
            y += 100;
        }
        for (IDiagramModel diagramModel : this.fDiagramRefsToAdd) {
            result.add(new AddDiagramModelReferenceCommand(this.getTargetContainer(), diagramModel, x, y));
            if ((x += 150) <= origin + 400) continue;
            x = origin;
            y += 100;
        }
        for (IArchimateRelationship relation : this.fRelationsToAdd) {
            List<IDiagramModelArchimateComponent> list = DiagramModelUtils.findDiagramModelComponentsForArchimateConcept(this.getTargetDiagramModel(), relation.getSource());
            List<IDiagramModelArchimateComponent> list2 = DiagramModelUtils.findDiagramModelComponentsForArchimateConcept(this.getTargetDiagramModel(), relation.getTarget());
            for (IDiagramModelComponent iDiagramModelComponent : list) {
                for (IDiagramModelComponent dcTarget : list2) {
                    if (!(iDiagramModelComponent instanceof IConnectable) || !(dcTarget instanceof IConnectable) || dcTarget == iDiagramModelComponent || DiagramModelUtils.hasDiagramModelArchimateConnection((IConnectable)iDiagramModelComponent, (IConnectable)dcTarget, relation) || iDiagramModelComponent instanceof IDiagramModelArchimateConnection && DiagramModelUtils.shouldBeHiddenConnection((IDiagramModelConnection)((IDiagramModelArchimateConnection)iDiagramModelComponent)) || dcTarget instanceof IDiagramModelArchimateConnection && DiagramModelUtils.shouldBeHiddenConnection((IDiagramModelConnection)((IDiagramModelArchimateConnection)dcTarget))) continue;
                    AddDiagramArchimateConnectionCommand cmd = new AddDiagramArchimateConnectionCommand((IConnectable)iDiagramModelComponent, (IConnectable)dcTarget, relation);
                    result.add(cmd);
                    diagramComponentsThatWereAdded.add(cmd.getConnection());
                }
            }
        }
        Boolean value = (Boolean)request.getExtendedData().get("add_element_connections");
        boolean addConnectionsToElements = value != null && value != false;
        for (IDiagramModelArchimateComponent iDiagramModelArchimateComponent : diagramComponentsThatWereAdded) {
            IArchimateConcept iArchimateConcept = iDiagramModelArchimateComponent.getArchimateConcept();
            for (IArchimateRelationship relation : ArchimateModelUtils.getAllRelationshipsForConcept((IArchimateConcept)iArchimateConcept)) {
                if (!addConnectionsToElements && !this.fRelationsToAdd.contains(relation)) continue;
                List<IDiagramModelArchimateComponent> sources = DiagramModelUtils.findDiagramModelComponentsForArchimateConcept(this.getTargetDiagramModel(), relation.getSource());
                List<IDiagramModelArchimateComponent> targets = DiagramModelUtils.findDiagramModelComponentsForArchimateConcept(this.getTargetDiagramModel(), relation.getTarget());
                for (IDiagramModelArchimateComponent iDiagramModelArchimateComponent2 : diagramComponentsThatWereAdded) {
                    IArchimateConcept archimateConcept2;
                    if (iDiagramModelArchimateComponent == iDiagramModelArchimateComponent2 || (archimateConcept2 = iDiagramModelArchimateComponent2.getArchimateConcept()) != relation.getSource()) continue;
                    sources.add(iDiagramModelArchimateComponent2);
                }
                for (IDiagramModelComponent iDiagramModelComponent : sources) {
                    if (!(iDiagramModelComponent instanceof IConnectable) || iArchimateConcept != relation.getTarget()) continue;
                    result.add(new AddDiagramArchimateConnectionCommand((IConnectable)iDiagramModelComponent, (IConnectable)iDiagramModelArchimateComponent, relation));
                }
                for (IDiagramModelComponent iDiagramModelComponent : targets) {
                    if (!(iDiagramModelComponent instanceof IConnectable) || iArchimateConcept != relation.getSource()) continue;
                    result.add(new AddDiagramArchimateConnectionCommand((IConnectable)iDiagramModelArchimateComponent, (IConnectable)iDiagramModelComponent, relation));
                }
            }
        }
        if (ConnectionPreferences.createRelationWhenAddingModelTreeElement() && this.getTargetContainer() instanceof IDiagramModelArchimateObject) {
            ArrayList<IDiagramModelArchimateObject> arrayList = new ArrayList<IDiagramModelArchimateObject>();
            for (IDiagramModelArchimateComponent iDiagramModelArchimateComponent : diagramComponentsThatWereAdded) {
                if (!(iDiagramModelArchimateComponent instanceof IDiagramModelArchimateObject)) continue;
                arrayList.add((IDiagramModelArchimateObject)iDiagramModelArchimateComponent);
            }
            CreateNestedArchimateConnectionsWithDialogCommand createNestedArchimateConnectionsWithDialogCommand = new CreateNestedArchimateConnectionsWithDialogCommand((IDiagramModelArchimateObject)this.getTargetContainer(), arrayList);
            result.add((Command)createNestedArchimateConnectionsWithDialogCommand);
        }
        return result;
    }

    private void getElementsToAdd(Object[] objects) {
        IArchimateModel targetArchimateModel = this.getTargetDiagramModel().getArchimateModel();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            IArchimateModel sourceArchimateModel;
            Object object = objectArray[n2];
            if (this.canDropObject(object) && (!(object instanceof IArchimateModelObject) || (sourceArchimateModel = ((IArchimateModelObject)object).getArchimateModel()) == targetArchimateModel)) {
                if (object instanceof IArchimateElement) {
                    this.addUniqueObjectToList(this.fElementsToAdd, (IArchimateElement)object);
                } else if (object instanceof IArchimateRelationship) {
                    IArchimateRelationship relationship = (IArchimateRelationship)object;
                    if (relationship.getSource() instanceof IArchimateRelationship || relationship.getTarget() instanceof IArchimateRelationship) {
                        IArchimateRelationship otherRelationship = relationship.getSource() instanceof IArchimateRelationship ? (IArchimateRelationship)relationship.getSource() : (IArchimateRelationship)relationship.getTarget();
                        List<IDiagramModelArchimateConnection> otherConnections = DiagramModelUtils.findDiagramModelConnectionsForRelation(this.getTargetDiagramModel(), otherRelationship);
                        if (!otherConnections.isEmpty()) {
                            for (IDiagramModelArchimateConnection otherConnection : otherConnections) {
                                if (DiagramModelUtils.shouldBeHiddenConnection((IDiagramModelConnection)otherConnection)) continue;
                                this.addUniqueObjectToList(this.fRelationsToAdd, relationship);
                                this.addRelationshipConcepts(relationship);
                                break;
                            }
                        }
                    } else {
                        this.addUniqueObjectToList(this.fRelationsToAdd, relationship);
                        this.addRelationshipConcepts(relationship);
                    }
                } else if (object instanceof IDiagramModel && object != this.getTargetDiagramModel()) {
                    this.addUniqueObjectToList(this.fDiagramRefsToAdd, (IDiagramModel)object);
                }
            }
            ++n2;
        }
    }

    private void addRelationshipConcepts(IArchimateRelationship relationship) {
        if (DiagramModelUtils.findDiagramModelComponentsForArchimateConcept(this.getTargetDiagramModel(), relationship.getSource()).isEmpty() && relationship.getSource() instanceof IArchimateElement) {
            this.addUniqueObjectToList(this.fElementsToAdd, (IArchimateElement)relationship.getSource());
        }
        if (DiagramModelUtils.findDiagramModelComponentsForArchimateConcept(this.getTargetDiagramModel(), relationship.getTarget()).isEmpty() && relationship.getTarget() instanceof IArchimateElement) {
            this.addUniqueObjectToList(this.fElementsToAdd, (IArchimateElement)relationship.getTarget());
        }
        if (relationship.getSource() instanceof IArchimateElement && relationship.getSource() == relationship.getTarget()) {
            int size = DiagramModelUtils.findDiagramModelObjectsForElement(this.getTargetDiagramModel(), (IArchimateElement)relationship.getSource()).size();
            for (IArchimateElement e : this.fElementsToAdd) {
                if (e != relationship.getSource()) continue;
                ++size;
            }
            if (size < 2) {
                this.fElementsToAdd.add((IArchimateElement)relationship.getSource());
            }
        }
    }

    private <T extends EObject> void addUniqueObjectToList(List<T> list, T element) {
        if (!list.contains(element)) {
            list.add(element);
        }
    }

    private boolean canDropObject(Object object) {
        return object instanceof IArchimateConcept || object instanceof IDiagramModel;
    }

    private static class AddDiagramArchimateConnectionCommand
    extends Command {
        private IDiagramModelArchimateConnection fConnection;
        private IConnectable fSource;
        private IConnectable fTarget;

        public AddDiagramArchimateConnectionCommand(IConnectable src, IConnectable tgt, IArchimateRelationship relationship) {
            this.fSource = src;
            this.fTarget = tgt;
            this.fConnection = ArchimateDiagramModelFactory.createDiagramModelArchimateConnection(relationship);
        }

        public IDiagramModelArchimateConnection getConnection() {
            return this.fConnection;
        }

        public void execute() {
            this.fConnection.connect(this.fSource, this.fTarget);
        }

        public void undo() {
            this.fConnection.disconnect();
        }

        public void redo() {
            this.fConnection.reconnect();
        }
    }
}

