/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.policies;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.commands.CreateDiagramArchimateConnectionWithDialogCommand;
import com.archimatetool.editor.diagram.commands.CreateDiagramConnectionCommand;
import com.archimatetool.editor.diagram.commands.DiagramCommandFactory;
import com.archimatetool.editor.diagram.commands.ReconnectDiagramConnectionCommand;
import com.archimatetool.editor.diagram.figures.ITargetFeedbackFigure;
import com.archimatetool.editor.diagram.policies.Messages;
import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelGroup;
import com.archimatetool.model.IDiagramModelNote;
import com.archimatetool.model.IDiagramModelReference;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ArchimateDiagramConnectionPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        CreateDiagramConnectionCommand cmd = null;
        EClass classType = (EClass)request.getNewObjectType();
        IConnectable source = (IConnectable)this.getHost().getModel();
        if (classType == IArchimatePackage.eINSTANCE.getDiagramModelConnection()) {
            if (ArchimateDiagramConnectionPolicy.isValidConnectionSource(source, classType)) {
                cmd = new CreateDiagramConnectionCommand(request);
            }
        } else if (source instanceof IDiagramModelArchimateComponent && ArchimateDiagramConnectionPolicy.isValidConnectionSource(source, classType)) {
            cmd = new CreateDiagramArchimateConnectionWithDialogCommand(request);
        }
        if (cmd != null) {
            cmd.setSource(source);
            request.setStartCommand((Command)cmd);
        }
        return cmd;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        IConnectable source = (IConnectable)request.getSourceEditPart().getModel();
        IConnectable target = (IConnectable)this.getHost().getModel();
        EClass relationshipType = (EClass)request.getNewObjectType();
        CreateDiagramConnectionCommand cmd = null;
        if (ArchimateDiagramConnectionPolicy.isValidConnection(source, target, relationshipType)) {
            cmd = (CreateDiagramConnectionCommand)request.getStartCommand();
            cmd.setTarget(target);
        }
        return cmd;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        return this.getReconnectCommand(request, true);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        return this.getReconnectCommand(request, false);
    }

    protected Command getReconnectCommand(ReconnectRequest request, boolean isSourceCommand) {
        IDiagramModelConnection connection = (IDiagramModelConnection)request.getConnectionEditPart().getModel();
        IConnectable newComponent = (IConnectable)this.getHost().getModel();
        EClass type = connection.eClass();
        if (connection instanceof IDiagramModelArchimateConnection) {
            IDiagramModelArchimateConnection archimateConnection = (IDiagramModelArchimateConnection)connection;
            type = archimateConnection.getArchimateRelationship().eClass();
        }
        if (isSourceCommand ? !ArchimateDiagramConnectionPolicy.isValidConnection(newComponent, connection.getTarget(), type) : !ArchimateDiagramConnectionPolicy.isValidConnection(connection.getSource(), newComponent, type)) {
            return null;
        }
        if (connection instanceof IDiagramModelArchimateConnection) {
            IDiagramModelArchimateConnection archimateConnection = (IDiagramModelArchimateConnection)connection;
            if (newComponent instanceof IDiagramModelArchimateComponent) {
                IDiagramModelArchimateComponent archimateComponent = (IDiagramModelArchimateComponent)newComponent;
                return this.createArchimateReconnectCommand(archimateConnection, archimateComponent, isSourceCommand);
            }
        }
        return this.createReconnectCommand(connection, newComponent, isSourceCommand);
    }

    private Command createArchimateReconnectCommand(final IDiagramModelArchimateConnection connection, final IDiagramModelArchimateComponent dmc, final boolean isSourceCommand) {
        final IArchimateRelationship relationship = connection.getArchimateRelationship();
        final IArchimateConcept newConcept = dmc.getArchimateConcept();
        CompoundCommand cmd = new CompoundCommand(){
            boolean affectsOtherViews = false;

            public void execute() {
                boolean answer;
                this.createCommands();
                super.execute();
                if (this.affectsOtherViews && ArchiPlugin.getInstance().getPreferenceStore().getBoolean("showWarningOnReconnect") && !(answer = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.ArchimateDiagramConnectionPolicy_0, (String)(Messages.ArchimateDiagramConnectionPolicy_1 + "\n\n" + Messages.ArchimateDiagramConnectionPolicy_2)))) {
                    Display.getDefault().asyncExec(() -> ((CommandStack)connection.getAdapter(CommandStack.class)).undo());
                }
            }

            public boolean canExecute() {
                return isSourceCommand ? connection.getSource() != dmc : connection.getTarget() != dmc;
            }

            private void createCommands() {
                for (IDiagramModelArchimateConnection matchingConnection : relationship.getReferencingDiagramConnections()) {
                    if (matchingConnection.getDiagramModel() == connection.getDiagramModel()) {
                        if (ArchimateDiagramConnectionPolicy.this.isNewConnection(matchingConnection, dmc, isSourceCommand)) {
                            this.add(ArchimateDiagramConnectionPolicy.this.createReconnectCommand((IDiagramModelConnection)matchingConnection, (IConnectable)dmc, isSourceCommand));
                            continue;
                        }
                        if (connection != matchingConnection) continue;
                        this.add(ArchimateDiagramConnectionPolicy.this.createReconnectCommand((IDiagramModelConnection)matchingConnection, (IConnectable)dmc, isSourceCommand));
                        continue;
                    }
                    List<IDiagramModelArchimateComponent> list = DiagramModelUtils.findDiagramModelComponentsForArchimateConcept(matchingConnection.getDiagramModel(), newConcept);
                    if (!list.isEmpty()) {
                        Command cmd;
                        IDiagramModelArchimateComponent newComponent = list.get(0);
                        if (!ArchimateDiagramConnectionPolicy.this.isNewConnection(matchingConnection, newComponent, isSourceCommand) || !(cmd = ArchimateDiagramConnectionPolicy.this.createReconnectCommand((IDiagramModelConnection)matchingConnection, (IConnectable)newComponent, isSourceCommand)).canExecute()) continue;
                        this.affectsOtherViews = true;
                        this.add(cmd);
                        continue;
                    }
                    this.add(DiagramCommandFactory.createDeleteDiagramConnectionCommand((IDiagramModelConnection)matchingConnection));
                    this.affectsOtherViews = true;
                }
            }
        };
        return cmd;
    }

    private boolean isNewConnection(IDiagramModelArchimateConnection connection, IDiagramModelArchimateComponent dmc, boolean isSourceCommand) {
        if (isSourceCommand) {
            return !dmc.getArchimateConcept().getSourceRelationships().contains((Object)connection.getArchimateConcept());
        }
        return !dmc.getArchimateConcept().getTargetRelationships().contains((Object)connection.getArchimateConcept());
    }

    private Command createReconnectCommand(IDiagramModelConnection connection, IConnectable connectable, boolean isSourceCommand) {
        ReconnectDiagramConnectionCommand cmd = new ReconnectDiagramConnectionCommand(connection);
        if (isSourceCommand) {
            cmd.setNewSource(connectable);
        } else {
            cmd.setNewTarget(connectable);
        }
        return cmd;
    }

    public void eraseTargetFeedback(Request request) {
        IFigure iFigure = ((GraphicalEditPart)this.getHost()).getFigure();
        if (iFigure instanceof ITargetFeedbackFigure) {
            ITargetFeedbackFigure figure = (ITargetFeedbackFigure)iFigure;
            figure.showTargetFeedback(false);
        }
    }

    public void showTargetFeedback(Request request) {
        if (request.getType().equals("connection start") && this.getConnectionCreateCommand((CreateConnectionRequest)request) != null) {
            this.showTargetFeedback();
        }
        if (request.getType().equals("connection end") && this.getConnectionCompleteCommand((CreateConnectionRequest)request) != null) {
            this.showTargetFeedback();
        }
        if (request.getType().equals("Reconnection source") && this.getReconnectSourceCommand((ReconnectRequest)request) != null) {
            this.showTargetFeedback();
        }
        if (request.getType().equals("Reconnection target") && this.getReconnectTargetCommand((ReconnectRequest)request) != null) {
            this.showTargetFeedback();
        }
    }

    private void showTargetFeedback() {
        IFigure iFigure = ((GraphicalEditPart)this.getHost()).getFigure();
        if (iFigure instanceof ITargetFeedbackFigure) {
            ITargetFeedbackFigure figure = (ITargetFeedbackFigure)iFigure;
            figure.showTargetFeedback(true);
        }
    }

    static boolean isValidConnectionSource(IConnectable source, EClass relationshipType) {
        if (relationshipType == null) {
            return true;
        }
        if (relationshipType == IArchimatePackage.eINSTANCE.getDiagramModelConnection()) {
            return true;
        }
        if (source instanceof IDiagramModelArchimateComponent) {
            IDiagramModelArchimateComponent dmc = (IDiagramModelArchimateComponent)source;
            return ArchimateModelUtils.isValidRelationshipStart((IArchimateConcept)dmc.getArchimateConcept(), (EClass)relationshipType);
        }
        return false;
    }

    static boolean isValidConnection(IConnectable source, IConnectable target, EClass relationshipType) {
        if (relationshipType == IArchimatePackage.eINSTANCE.getDiagramModelConnection()) {
            if (source instanceof IDiagramModelNote || target instanceof IDiagramModelNote) {
                return true;
            }
            if (source instanceof IDiagramModelGroup || target instanceof IDiagramModelGroup) {
                return true;
            }
            return source instanceof IDiagramModelReference || target instanceof IDiagramModelReference;
        }
        if (source instanceof IDiagramModelArchimateComponent) {
            IDiagramModelArchimateComponent archimateSource = (IDiagramModelArchimateComponent)source;
            if (target instanceof IDiagramModelArchimateComponent) {
                IDiagramModelArchimateComponent archimateTarget = (IDiagramModelArchimateComponent)target;
                if (!(source instanceof IDiagramModelArchimateConnection) || !(target instanceof IDiagramModelArchimateConnection)) {
                    if (relationshipType == null) {
                        return true;
                    }
                    return ArchimateModelUtils.isValidRelationship((IArchimateConcept)archimateSource.getArchimateConcept(), (IArchimateConcept)archimateTarget.getArchimateConcept(), (EClass)relationshipType);
                }
            }
        }
        return false;
    }
}

