/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.policies;

import com.archimatetool.editor.diagram.commands.CreateDiagramConnectionCommand;
import com.archimatetool.editor.diagram.commands.ReconnectDiagramConnectionCommand;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class BasicConnectionPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        CreateDiagramConnectionCommand cmd = null;
        EClass classType = (EClass)request.getNewObjectType();
        IDiagramModelObject source = (IDiagramModelObject)this.getHost().getModel();
        if (this.isValidConnectionSource((IConnectable)source, classType)) {
            cmd = new CreateDiagramConnectionCommand(request);
            cmd.setSource((IConnectable)source);
            request.setStartCommand((Command)cmd);
        }
        return cmd;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        IConnectable source = (IConnectable)request.getSourceEditPart().getModel();
        IConnectable target = (IConnectable)this.getHost().getModel();
        EClass relationshipType = (EClass)request.getNewObjectType();
        CreateDiagramConnectionCommand cmd = null;
        if (this.isValidConnection(source, target, relationshipType)) {
            cmd = (CreateDiagramConnectionCommand)request.getStartCommand();
            cmd.setTarget(target);
        }
        return cmd;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        ReconnectDiagramConnectionCommand cmd = null;
        IDiagramModelConnection connection = (IDiagramModelConnection)request.getConnectionEditPart().getModel();
        IDiagramModelObject newSource = (IDiagramModelObject)this.getHost().getModel();
        if (this.isValidConnectionSource((IConnectable)newSource, connection.eClass())) {
            cmd = new ReconnectDiagramConnectionCommand(connection);
            cmd.setNewSource((IConnectable)newSource);
        }
        return cmd;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        ReconnectDiagramConnectionCommand cmd = null;
        IDiagramModelConnection connection = (IDiagramModelConnection)request.getConnectionEditPart().getModel();
        IDiagramModelObject newTarget = (IDiagramModelObject)this.getHost().getModel();
        if (this.isValidConnectionTarget((IConnectable)newTarget, connection.eClass())) {
            cmd = new ReconnectDiagramConnectionCommand(connection);
            cmd.setNewTarget((IConnectable)newTarget);
        }
        return cmd;
    }

    protected boolean isValidConnectionSource(IConnectable source, EClass relationshipType) {
        return true;
    }

    protected boolean isValidConnectionTarget(IConnectable target, EClass relationshipType) {
        return true;
    }

    protected boolean isValidConnection(IConnectable source, IConnectable target, EClass relationshipType) {
        return this.isValidConnectionSource(source, relationshipType) && this.isValidConnectionTarget(target, relationshipType);
    }
}

