/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.policies;

import com.archimatetool.editor.diagram.commands.CreateBendpointCommand;
import com.archimatetool.editor.diagram.commands.DeleteBendpointCommand;
import com.archimatetool.editor.diagram.commands.MoveBendpointCommand;
import com.archimatetool.editor.diagram.policies.snaptogrid.ExtendedBendpointEditPolicy;
import com.archimatetool.model.IDiagramModelConnection;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.BendpointRequest;

public class ManualBendpointEditPolicy
extends ExtendedBendpointEditPolicy {
    protected Command getCreateBendpointCommand(BendpointRequest request) {
        CreateBendpointCommand command = new CreateBendpointCommand();
        Point p = request.getLocation();
        Connection conn = this.getConnection();
        conn.translateToRelative((Translatable)p);
        command.setLocation(p);
        Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ref1);
        conn.translateToRelative((Translatable)ref2);
        command.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
        command.setDiagramModelConnection((IDiagramModelConnection)request.getSource().getModel());
        command.setIndex(request.getIndex());
        return command;
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        DeleteBendpointCommand command = new DeleteBendpointCommand();
        Point p = request.getLocation();
        command.setLocation(p);
        command.setDiagramModelConnection((IDiagramModelConnection)request.getSource().getModel());
        command.setIndex(request.getIndex());
        return command;
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        MoveBendpointCommand command = new MoveBendpointCommand();
        Point p = request.getLocation();
        Connection conn = this.getConnection();
        conn.translateToRelative((Translatable)p);
        command.setLocation(p);
        Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ref1);
        conn.translateToRelative((Translatable)ref2);
        command.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
        command.setDiagramModelConnection((IDiagramModelConnection)request.getSource().getModel());
        command.setIndex(request.getIndex());
        return command;
    }
}

