/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.policies.snaptogrid;

import com.archimatetool.editor.diagram.policies.snaptogrid.ExtendedBendpointCreationHandle;
import com.archimatetool.editor.diagram.policies.snaptogrid.ExtendedBendpointMoveHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;

public abstract class ExtendedBendpointEditPolicy
extends BendpointEditPolicy {
    private static final List NULL_CONSTRAINT = new ArrayList();

    private List createHandlesForAutomaticBendpoints() {
        ArrayList<ExtendedBendpointCreationHandle> list = new ArrayList<ExtendedBendpointCreationHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        int i = 0;
        while (i < points.size() - 1) {
            list.add(new ExtendedBendpointCreationHandle(connEP, 0, i));
            ++i;
        }
        return list;
    }

    private List createHandlesForUserBendpoints() {
        ArrayList<Object> list = new ArrayList<Object>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        List bendPoints = (List)this.getConnection().getRoutingConstraint();
        int bendPointIndex = 0;
        Point currBendPoint = null;
        if (bendPoints == null) {
            bendPoints = NULL_CONSTRAINT;
        } else if (!bendPoints.isEmpty()) {
            currBendPoint = ((Bendpoint)bendPoints.get(0)).getLocation();
        }
        int i = 0;
        while (i < points.size() - 1) {
            list.add((Object)new ExtendedBendpointCreationHandle(connEP, bendPointIndex, i));
            if (i < points.size() - 1 && bendPointIndex < bendPoints.size() && currBendPoint.equals((Object)points.getPoint(i + 1))) {
                list.add((Object)new ExtendedBendpointMoveHandle(connEP, bendPointIndex, i + 1));
                if (++bendPointIndex < bendPoints.size()) {
                    currBendPoint = ((Bendpoint)bendPoints.get(bendPointIndex)).getLocation();
                }
            }
            ++i;
        }
        return list;
    }

    protected List createSelectionHandles() {
        List list = new ArrayList();
        list = this.isAutomaticallyBending() ? this.createHandlesForAutomaticBendpoints() : this.createHandlesForUserBendpoints();
        return list;
    }

    private boolean isAutomaticallyBending() {
        List constraint = (List)this.getConnection().getRoutingConstraint();
        PointList points = this.getConnection().getPoints();
        return points.size() > 2 && (constraint == null || constraint.isEmpty());
    }
}

