/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.sketch;

import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class BackgroundImageLayer
extends FreeformLayer {
    public static final String NAME = "BackgroundImageLayer";
    private Image fBackgroundImage;
    private int fImageWidth;
    private int fImageHeight;

    public BackgroundImageLayer() {
    }

    public BackgroundImageLayer(Image image) {
        this.setImage(image);
    }

    public void setImage(Image image) {
        this.fBackgroundImage = image;
        if (this.fBackgroundImage != null) {
            this.fImageWidth = this.fBackgroundImage.getBounds().width;
            this.fImageHeight = this.fBackgroundImage.getBounds().height;
        }
        this.repaint();
    }

    public void paintFigure(Graphics graphics) {
        if (this.fBackgroundImage != null) {
            Rectangle bounds = this.getBounds();
            int x = bounds.x;
            while (x < bounds.width) {
                int y = bounds.y;
                while (y < bounds.height) {
                    graphics.drawImage(this.fBackgroundImage, x, y);
                    y += this.fImageHeight;
                }
                x += this.fImageWidth;
            }
        }
    }
}

