/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.sketch;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.ICreationFactory;
import com.archimatetool.editor.diagram.sketch.ISketchEditor;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.factory.IGraphicalObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelGroup;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.ISketchModelActor;
import com.archimatetool.model.ISketchModelSticky;
import com.archimatetool.model.ITextAlignment;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;

public class SketchModelFactory
implements ICreationFactory {
    private EClass fTemplate;
    private Object fParam;

    public SketchModelFactory(EClass template) {
        this(template, null);
    }

    @Override
    public boolean isUsedFor(IEditorPart editor) {
        return editor instanceof ISketchEditor;
    }

    public SketchModelFactory(EClass template, Object param) {
        this.fTemplate = template;
        this.fParam = param;
    }

    public Object getNewObject() {
        EObject object = IArchimateFactory.eINSTANCE.create(this.fTemplate);
        IGraphicalObjectUIProvider provider = (IGraphicalObjectUIProvider)ObjectUIFactory.INSTANCE.getProvider(object);
        if (object instanceof ISketchModelActor) {
            ISketchModelActor actor = (ISketchModelActor)object;
            actor.setName(ArchiLabelProvider.INSTANCE.getDefaultName(this.fTemplate));
        } else if (object instanceof ISketchModelSticky) {
            ISketchModelSticky sticky = (ISketchModelSticky)object;
            sticky.setName(ArchiLabelProvider.INSTANCE.getDefaultName(this.fTemplate));
            sticky.setDeriveElementLineColor(ArchiPlugin.getInstance().getPreferenceStore().getBoolean("deriveElementLineColor"));
            sticky.setGradient(ArchiPlugin.getInstance().getPreferenceStore().getInt("defaultGradient"));
            Object object2 = this.fParam;
            if (object2 instanceof RGB) {
                Color lineColor;
                RGB rgb = (RGB)object2;
                if (!rgb.equals((Object)provider.getDefaultColor().getRGB())) {
                    String color = ColorFactory.convertRGBToString(rgb);
                    sticky.setFillColor(color);
                }
                if ((lineColor = ColorFactory.getDefaultLineColor(sticky)) != null) {
                    sticky.setLineColor(ColorFactory.convertColorToString(lineColor));
                }
            }
        } else if (object instanceof IDiagramModelGroup) {
            IDiagramModelGroup group = (IDiagramModelGroup)object;
            group.setName(ArchiLabelProvider.INSTANCE.getDefaultName(this.fTemplate));
            ColorFactory.setDefaultColors((IDiagramModelComponent)group);
            group.setGradient(ArchiPlugin.getInstance().getPreferenceStore().getInt("defaultGradient"));
        } else if (object instanceof IDiagramModelConnection) {
            IDiagramModelConnection connection = (IDiagramModelConnection)object;
            Object object3 = this.fParam;
            if (object3 instanceof Integer) {
                Integer i = (Integer)object3;
                connection.setType(i.intValue());
            }
            ColorFactory.setDefaultColors((IDiagramModelComponent)connection);
        }
        if (object instanceof ITextAlignment) {
            ITextAlignment ta = (ITextAlignment)object;
            ta.setTextAlignment(provider.getDefaultTextAlignment());
        }
        if (object instanceof ITextPosition) {
            ITextPosition tp = (ITextPosition)object;
            tp.setTextPosition(provider.getDefaultTextPosition());
        }
        if (object instanceof IDiagramModelObject) {
            IDiagramModelObject dmo = (IDiagramModelObject)object;
            Dimension size = provider.getDefaultSize();
            dmo.setBounds(0, 0, size.width, size.height);
        }
        return object;
    }

    public Object getObjectType() {
        return this.fTemplate;
    }
}

