/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.tools;

import com.archimatetool.editor.Logger;
import com.archimatetool.editor.diagram.commands.BorderColorCommand;
import com.archimatetool.editor.diagram.commands.ConnectionLineTypeCommand;
import com.archimatetool.editor.diagram.commands.ConnectionTextPositionCommand;
import com.archimatetool.editor.diagram.commands.DiagramModelObjectAlphaCommand;
import com.archimatetool.editor.diagram.commands.DiagramModelObjectLineStyleCommand;
import com.archimatetool.editor.diagram.commands.DiagramModelObjectOutlineAlphaCommand;
import com.archimatetool.editor.diagram.commands.FillColorCommand;
import com.archimatetool.editor.diagram.commands.FontColorCommand;
import com.archimatetool.editor.diagram.commands.FontStyleCommand;
import com.archimatetool.editor.diagram.commands.LineColorCommand;
import com.archimatetool.editor.diagram.commands.LineWidthCommand;
import com.archimatetool.editor.diagram.commands.TextAlignmentCommand;
import com.archimatetool.editor.diagram.commands.TextPositionCommand;
import com.archimatetool.editor.diagram.tools.FormatPainterInfo;
import com.archimatetool.editor.diagram.tools.Messages;
import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.model.commands.FeatureCommand;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.factory.IGraphicalObjectUIProvider;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IBorderObject;
import com.archimatetool.model.IBorderType;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelImage;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IFeatures;
import com.archimatetool.model.IFontAttribute;
import com.archimatetool.model.IIconic;
import com.archimatetool.model.IJunction;
import com.archimatetool.model.ILineObject;
import com.archimatetool.model.ILockable;
import com.archimatetool.model.ITextAlignment;
import com.archimatetool.model.ITextPosition;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.tools.AbstractTool;

public class FormatPainterTool
extends AbstractTool {
    public FormatPainterTool() {
        this.setDefaultCursor(FormatPainterInfo.INSTANCE.getCursor());
    }

    protected boolean handleButtonUp(int button) {
        if (button == 1) {
            Point pt = this.getLocation();
            EditPart editpart = this.getCurrentViewer().findObjectAt(pt);
            if (editpart != null && editpart.getModel() != null) {
                Object object = editpart.getModel();
                if (this.isPaintableObject(object)) {
                    CompoundCommand cmd;
                    if (FormatPainterInfo.INSTANCE.getSourceComponent() == null) {
                        FormatPainterInfo.INSTANCE.updateWithSourceComponent((IDiagramModelComponent)object);
                    } else if (!this.isObjectLocked(object) && (cmd = this.createCommand((IDiagramModelComponent)object)).canExecute()) {
                        this.executeCommand((Command)cmd);
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected boolean handleDoubleClick(int button) {
        if (button == 1) {
            Point pt = this.getLocation();
            EditPart editpart = this.getCurrentViewer().findObjectAt(pt);
            if (editpart == this.getCurrentViewer().getRootEditPart()) {
                FormatPainterInfo.INSTANCE.reset();
                return true;
            }
        }
        return false;
    }

    CompoundCommand createCommand(IDiagramModelComponent targetComponent) {
        CompoundCommand result = new CompoundCommand(Messages.FormatPainterTool_0);
        IDiagramModelComponent sourceComponent = FormatPainterInfo.INSTANCE.getSourceComponent();
        IObjectUIProvider sourceUIProvider = ObjectUIFactory.INSTANCE.getProvider((EObject)sourceComponent);
        IObjectUIProvider targetUIProvider = ObjectUIFactory.INSTANCE.getProvider((EObject)targetComponent);
        if (sourceComponent instanceof IFontAttribute) {
            IFontAttribute source = (IFontAttribute)sourceComponent;
            if (targetComponent instanceof IFontAttribute) {
                IFontAttribute target = (IFontAttribute)targetComponent;
                EObjectFeatureCommand cmd = new FontStyleCommand(target, source.getFont());
                if (cmd.canExecute()) {
                    result.add((Command)cmd);
                }
                if ((cmd = new FontColorCommand(target, source.getFontColor())).canExecute()) {
                    result.add((Command)cmd);
                }
            }
        }
        if (sourceComponent instanceof ILineObject) {
            ILineObject source = (ILineObject)sourceComponent;
            if (targetComponent instanceof ILineObject) {
                ILineObject target = (ILineObject)targetComponent;
                if (targetUIProvider != null) {
                    EObjectFeatureCommand cmd;
                    if (targetUIProvider.shouldExposeFeature(IArchimatePackage.Literals.LINE_OBJECT__LINE_COLOR.getName()) && (cmd = new LineColorCommand(target, source.getLineColor())).canExecute()) {
                        result.add((Command)cmd);
                    }
                    if (targetUIProvider.shouldExposeFeature(IArchimatePackage.Literals.LINE_OBJECT__LINE_WIDTH.getName()) && (cmd = new LineWidthCommand(target, source.getLineWidth())).canExecute()) {
                        result.add((Command)cmd);
                    }
                }
            }
        }
        if (sourceComponent instanceof IBorderObject) {
            IBorderObject target;
            BorderColorCommand cmd;
            IBorderObject source = (IBorderObject)sourceComponent;
            if (targetComponent instanceof IBorderObject && (cmd = new BorderColorCommand(target = (IBorderObject)targetComponent, source.getBorderColor())).canExecute()) {
                result.add((Command)cmd);
            }
        }
        if (sourceComponent instanceof IBorderType) {
            IBorderType source = (IBorderType)sourceComponent;
            if (targetComponent instanceof IBorderType) {
                EObjectFeatureCommand cmd;
                IBorderType target = (IBorderType)targetComponent;
                if (source.eClass() == target.eClass() && (cmd = new EObjectFeatureCommand("", (EObject)target, (EStructuralFeature)IArchimatePackage.Literals.BORDER_TYPE__BORDER_TYPE, source.getBorderType())).canExecute()) {
                    result.add((Command)cmd);
                }
            }
        }
        if (sourceComponent instanceof ITextPosition) {
            ITextPosition target;
            TextPositionCommand cmd;
            ITextPosition source = (ITextPosition)sourceComponent;
            if (targetComponent instanceof ITextPosition && (cmd = new TextPositionCommand(target = (ITextPosition)targetComponent, source.getTextPosition())).canExecute()) {
                result.add((Command)cmd);
            }
        }
        if (sourceComponent instanceof ITextAlignment) {
            ITextAlignment target;
            TextAlignmentCommand cmd;
            ITextAlignment source = (ITextAlignment)sourceComponent;
            if (targetComponent instanceof ITextAlignment && (cmd = new TextAlignmentCommand(target = (ITextAlignment)targetComponent, source.getTextAlignment())).canExecute()) {
                result.add((Command)cmd);
            }
        }
        if (sourceComponent instanceof IDiagramModelObject) {
            IDiagramModelObject source = (IDiagramModelObject)sourceComponent;
            if (targetComponent instanceof IDiagramModelObject) {
                Command cmd;
                String targetfillColor;
                IDiagramModelObject target = (IDiagramModelObject)targetComponent;
                String sourcefillColor = source.getFillColor();
                if (sourcefillColor == null) {
                    sourcefillColor = ColorFactory.convertColorToString(ColorFactory.getDefaultFillColor(source));
                }
                if ((targetfillColor = target.getFillColor()) == null) {
                    targetfillColor = ColorFactory.convertColorToString(ColorFactory.getDefaultFillColor(target));
                }
                if (!Objects.equals(sourcefillColor, targetfillColor) && (cmd = new FillColorCommand(target, sourcefillColor)).canExecute()) {
                    result.add(cmd);
                }
                if ((cmd = new DiagramModelObjectAlphaCommand(target, source.getAlpha())).canExecute()) {
                    result.add(cmd);
                }
                if ((cmd = new DiagramModelObjectOutlineAlphaCommand(target, source.getLineAlpha())).canExecute()) {
                    result.add(cmd);
                }
                if (targetUIProvider != null && sourceUIProvider != null && targetUIProvider.shouldExposeFeature("lineStyle") && (cmd = new DiagramModelObjectLineStyleCommand(target, (Integer)sourceUIProvider.getFeatureValue("lineStyle"))).canExecute()) {
                    result.add(cmd);
                }
                if (targetUIProvider != null && targetUIProvider.shouldExposeFeature("gradient") && (cmd = new FeatureCommand("", (IFeatures)target, "gradient", source.getGradient(), -1)).canExecute()) {
                    result.add(cmd);
                }
                if (targetUIProvider != null && targetUIProvider.shouldExposeFeature("deriveElementLineColor") && (cmd = new FeatureCommand("", (IFeatures)target, "deriveElementLineColor", source.getDeriveElementLineColor(), true)).canExecute()) {
                    result.add(cmd);
                }
                if (targetUIProvider instanceof IGraphicalObjectUIProvider && ((IGraphicalObjectUIProvider)targetUIProvider).hasIcon()) {
                    cmd = new FeatureCommand("", (IFeatures)target, "iconVisible", source.getIconVisibleState(), 0);
                    if (cmd.canExecute()) {
                        result.add(cmd);
                    }
                    if ((cmd = new FeatureCommand("", (IFeatures)target, "iconColor", source.getIconColor(), "")).canExecute()) {
                        result.add(cmd);
                    }
                }
            }
        }
        if (sourceComponent instanceof IDiagramModelArchimateObject) {
            IDiagramModelArchimateObject target;
            FeatureCommand cmd;
            IDiagramModelArchimateObject source = (IDiagramModelArchimateObject)sourceComponent;
            if (targetComponent instanceof IDiagramModelArchimateObject && (cmd = new FeatureCommand("", (IFeatures)(target = (IDiagramModelArchimateObject)targetComponent), "imageSource", source.getImageSource(), 0)).canExecute()) {
                result.add((Command)cmd);
            }
        }
        if (sourceComponent instanceof IDiagramModelConnection) {
            IDiagramModelConnection source = (IDiagramModelConnection)sourceComponent;
            if (targetComponent instanceof IDiagramModelConnection) {
                IDiagramModelConnection target = (IDiagramModelConnection)targetComponent;
                EObjectFeatureCommand cmd = new ConnectionTextPositionCommand(target, source.getTextPosition());
                if (cmd.canExecute()) {
                    result.add((Command)cmd);
                }
                if (!(target instanceof IDiagramModelArchimateConnection) && (cmd = new ConnectionLineTypeCommand(target, source.getType())).canExecute()) {
                    result.add((Command)cmd);
                }
            }
        }
        if (sourceComponent instanceof IIconic) {
            IIconic source = (IIconic)sourceComponent;
            if (targetComponent instanceof IIconic) {
                EObjectFeatureCommand cmd;
                IIconic target = (IIconic)targetComponent;
                String imagePath = source.getImagePath();
                if (imagePath != null && FormatPainterInfo.INSTANCE.getSourceImageBytes() != null) {
                    IArchiveManager targetArchiveManager = (IArchiveManager)target.getAdapter(IArchiveManager.class);
                    try {
                        imagePath = targetArchiveManager.addByteContentEntry(imagePath, FormatPainterInfo.INSTANCE.getSourceImageBytes());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        Logger.logError("Could not copy image bytes when copying and pasting objects.", ex);
                    }
                }
                if ((cmd = new EObjectFeatureCommand("", (EObject)target, (EStructuralFeature)IArchimatePackage.Literals.DIAGRAM_MODEL_IMAGE_PROVIDER__IMAGE_PATH, imagePath)).canExecute()) {
                    result.add((Command)cmd);
                }
                if ((cmd = new EObjectFeatureCommand("", (EObject)target, (EStructuralFeature)IArchimatePackage.Literals.ICONIC__IMAGE_POSITION, source.getImagePosition())).canExecute()) {
                    result.add((Command)cmd);
                }
            }
        }
        return result;
    }

    private boolean isObjectLocked(Object object) {
        ILockable lockable;
        return object instanceof ILockable && (lockable = (ILockable)object).isLocked();
    }

    boolean isPaintableObject(Object object) {
        if (object instanceof IDiagramModelArchimateObject) {
            IDiagramModelArchimateObject dmo = (IDiagramModelArchimateObject)object;
            IArchimateElement element = dmo.getArchimateElement();
            return !(element instanceof IJunction);
        }
        if (object instanceof IDiagramModelImage) {
            return false;
        }
        return object instanceof IDiagramModelObject || object instanceof IDiagramModelConnection;
    }

    protected String getCommandName() {
        return "FormatPaint";
    }
}

