/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model;

import com.archimatetool.editor.model.impl.ArchiveManager;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.util.ArchimateResourceFactory;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public interface IArchiveManager {
    public boolean useArchiveFormat();

    public String addImageFromFile(File var1) throws IOException;

    public String addByteContentEntry(String var1, byte[] var2) throws IOException;

    public String copyImageBytes(IArchiveManager var1, String var2) throws IOException;

    public byte[] getBytesFromEntry(String var1);

    public Image createImage(String var1) throws Exception;

    public ImageData createImageData(String var1);

    public Set<String> getImagePaths();

    public Set<String> getLoadedImagePaths();

    public void saveModel() throws IOException;

    public IArchiveManager clone(IArchimateModel var1);

    public void loadImages() throws IOException;

    public boolean loadImagesFromModelFile(File var1) throws IOException;

    public boolean hasImages();

    public void dispose();

    public static class FACTORY {
        public static IArchiveManager createArchiveManager(IArchimateModel model) {
            return new ArchiveManager(model);
        }

        public static boolean isArchiveFile(File file) {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try (ZipFile zipFile = new ZipFile(file);){
                    boolean bl = zipFile.getEntry("model.xml") != null;
                    return bl;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }

        public static Resource createResource(File file) {
            return ArchimateResourceFactory.createNewResource((URI)(FACTORY.isArchiveFile(file) ? FACTORY.createArchiveModelURI(file) : URI.createFileURI((String)file.getAbsolutePath())));
        }

        public static URI createArchiveModelURI(File file) {
            return URI.createURI((String)(FACTORY.getArchiveFilePath(file) + "!/model.xml"));
        }

        public static String getArchiveFilePath(File file) {
            String path = file.getAbsolutePath();
            path = path.replace("#", "%23");
            return "archive:file:///" + path;
        }
    }
}

